<?PHP
/*
  include/class.calendar.php - 4/3/2009 - 8:32pm PST - 4.1.9
  
  SunShop Shopping Cart
  http://www.turnkeywebtools.com/sunshop/
  
  Copyright (c) 2001-2009 Turnkey Web Tools, Inc.
*/

class Calendar {
    function Calendar() { }
    
	function getDayNames() {
		return $this->dayNames;
	}
	
	function setDayNames($names) {
  		$this->dayNames = $names;
  	}
    
	function getMonthNames() {
        return $this->monthNames;
	}
    
    function setMonthNames($names) {
        $this->monthNames = $names;
    }
    
    function getStartDay() {
        return $this->startDay;
    }
    
    function setStartDay($day) {
        $this->startDay = $day;
    }
	
    function getStartMonth() {
        return $this->startMonth;
    }
    
    function setStartMonth($month) {
        $this->startMonth = $month;
    }
    
    function getCalendarLink($month, $year) {
        return "adminindex.php?action=transactions&sub=stats&month=$month&year=$year";
    }
    
    function getDateLink($day, $month, $year) {
        return "adminindex.php?action=transactions&sub=stats&month=$month&day=$day&year=$year";
    }
	
    function getCurrentMonthView() {
        $d = getdate(time());
        return $this->getMonthView($d["mon"], $d["day"], $d["year"]);
    }
    
    function getMonthView($month, $day, $year, $theme_path) {
		$this->theme_path = $theme_path;
        return $this->getMonthHTML($month, $day, $year);
    }
    
    function getDaysInMonth($month, $year) {
        if ($month < 1 || $month > 12) {
            return 0;
        }
        $d = $this->daysInMonth[$month - 1];
        if ($month == 2) {
            if ($year%4 == 0) {
                if ($year%100 == 0) {
                    if ($year%400 == 0) {
                        $d = 29;
                    }
                } else {
                    $d = 29;
                }
            }
        }
        return $d;
    }
	
    function getMonthHTML($m, $da, $y, $showYear = 1) {
    	$s = "";
        
		$a = $this->adjustDate($m, $y);
		$month = $a[0];
		$year = $a[1];
        
    	$daysInMonth = $this->getDaysInMonth($month, $year);
    	$date = getdate(mktime(12, 0, 0, $month, 1, $year));
    	
    	$first = $date["wday"];
    	$monthName = $this->monthNames[$month - 1];
    	
    	$prev = $this->adjustDate($month - 1, $year);
		$onm  = $this->adjustDate($month, $year);
    	$next = $this->adjustDate($month + 1, $year);
    	
    	if ($showYear == 1) {
    	    $prevMonth = $this->getCalendarLink($prev[0], $prev[1]);
    	    $nextMonth = $this->getCalendarLink($next[0], $next[1]);
			$thisMonth = $this->getCalendarLink($onm[0], $onm[1]);
    	} else {
    	    $prevMonth = "";
    	    $nextMonth = "";
    	}
    	
    	$header = $monthName . (($showYear > 0) ? " " . $year : "");
    	
    	$s .= "<table class=\"calendar\" width=\"100%\">\n";
    	$s .= "<tr>\n";
    	$s .= "<td align=\"center\" valign=\"top\">" . (($prevMonth == "") ? "&nbsp;" : "<a href=\"$prevMonth\"><img src=\"$this->theme_path/images/cal_back.gif\" height=\"14\" width=\"14\" alt=\"&lt;&lt;\" border=\"0\"></a>")  . "</td>\n";
    	$s .= "<td align=\"center\" valign=\"top\" class=\"calendarHeader\" colspan=\"5\"><a href=\"$thisMonth\">$header</a></td>\n"; 
    	$s .= "<td align=\"center\" valign=\"top\">" . (($nextMonth == "") ? "&nbsp;" : "<a href=\"$nextMonth\"><img src=\"$this->theme_path/images/cal_forward.gif\" height=\"14\" width=\"14\" alt=\"&gt;&gt;\" border=\"0\"></a>")  . "</td>\n";
    	$s .= "</tr>\n";
    	
    	$s .= "<tr>\n";
    	$s .= "<td align=\"center\" valign=\"top\" class=\"calendarHeader\">" . $this->dayNames[($this->startDay)%7] . "</td>\n";
    	$s .= "<td align=\"center\" valign=\"top\" class=\"calendarHeader\">" . $this->dayNames[($this->startDay+1)%7] . "</td>\n";
    	$s .= "<td align=\"center\" valign=\"top\" class=\"calendarHeader\">" . $this->dayNames[($this->startDay+2)%7] . "</td>\n";
    	$s .= "<td align=\"center\" valign=\"top\" class=\"calendarHeader\">" . $this->dayNames[($this->startDay+3)%7] . "</td>\n";
    	$s .= "<td align=\"center\" valign=\"top\" class=\"calendarHeader\">" . $this->dayNames[($this->startDay+4)%7] . "</td>\n";
    	$s .= "<td align=\"center\" valign=\"top\" class=\"calendarHeader\">" . $this->dayNames[($this->startDay+5)%7] . "</td>\n";
    	$s .= "<td align=\"center\" valign=\"top\" class=\"calendarHeader\">" . $this->dayNames[($this->startDay+6)%7] . "</td>\n";
    	$s .= "</tr>\n";
    	
    	$d = $this->startDay + 1 - $first;
    	while ($d > 1) {
    	    $d -= 7;
    	}

        $today = getdate(time());
    	while ($d <= $daysInMonth) {
    	    $s .= "<tr>\n";       
    	    
    	    for ($i = 0; $i < 7; $i++) {
        	    $class = ($year == $today["year"] && $month == $today["mon"] && $d == $da && $da != "") ? "calendarToday" : "calendar";
    	        $s .= "<td class=\"$class\" align=\"center\" valign=\"top\">";       
    	        if ($d > 0 && $d <= $daysInMonth) {
    	            $link = $this->getDateLink($d, $month, $year);
    	            $s .= (($link == "") ? $d : "<a href=\"$link\">$d</a>");
    	        } else {
    	            $s .= "&nbsp;";
    	        }
      	        $s .= "</td>\n";       
        	    $d++;
    	    }
    	    $s .= "</tr>\n";    
    	}
    	$s .= "</table>\n";
    	return $s;
    }
    
    function adjustDate($month, $year) {
        $a = array();  
        $a[0] = $month;
        $a[1] = $year;
        
        while ($a[0] > 12) {
            $a[0] -= 12;
            $a[1]++;
        }
        
        while ($a[0] <= 0) {
            $a[0] += 12;
            $a[1]--;
        }
        
        return $a;
    }

    var $startDay = 0;
    var $startMonth = 1;
    var $dayNames = array("S", "M", "T", "W", "Th", "F", "Sat");
    var $monthNames = array("January", "February", "March", "April", "May", "June",
                            "July", "August", "September", "October", "November", "December");
    var $daysInMonth = array(31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31);
}
?>