<?php
/*
  include/class.ftp.php - 4/3/2009 - 8:32pm PST - 4.1.9
  
  SunShop Shopping Cart
  http://www.turnkeywebtools.com/sunshop/
  
  Copyright (c) 2001-2009 Turnkey Web Tools, Inc.
*/

DEFINE (FPERM, 0);
DEFINE (FINODE, 1);
DEFINE (FUID, 2);
DEFINE (FGID, 3);
DEFINE (FSIZE, 4);
DEFINE (FMONTH, 5);
DEFINE (FDAY, 7);
DEFINE (FTIME, 7);
DEFINE (FNAME, 8);

class FTP {
	var $host;
	
	var $sock;
	var $data_sock;
	
	var $errno;
	var $errstr;
	var $message;
	
	var $user="anonymous";
	var $pass="nobody@nobody.com";
	
	var $enable_log = 1;
	
	function FTP($host, $port=21) {
		$this->log("host=$host, $port=$port");
		$this->host = $host;
		$this->port = $port;
	}
	
	function connect() {
		$this->sock = @fsockopen($this->host, $this->port, &$this->errno, &$this->errstr, 30);
		@set_socket_blocking($this->sock, false);
		return $this->sock;
	}
	
	function sock_read($i=0) {
		$s = fgets($this->sock, 4096);
		
		if ($s=='') {
			if($i==10) return "";
			else {
				sleep(1);
				return $this->sock_read($i+1);
			}
		}
		$this->log("<< $s");
		return $s;
	}
	
	function cdup() {
		$this->sock_write("CDUP");
		return $this->is_ok();
	}
	
	function binary() {
		$this->sock_write("TYPE I");
		return $this->is_ok();
	}
	
	function ascii() {
		$this->sock_write("TYPE A");
		return $this->is_ok();
	}
	
	function cwd($path) {
		$this->sock_write("CWD $path");
		return $this->check_reply("250");
	}
	
	function mkd($path) {
		$this->sock_write("MKD $path");
		return $this->check_reply("257");
	}
	
	function rmd($path) {
		$this->sock_write("RMD $path");
		return $this->check_reply("250");
	}
	
	function dele($path) {
		$this->sock_write("DELE $path");
		return $this->check_reply("250");
	}
	
	function pwd() {
		$this->sock_write("PWD");
		if ($this->check_reply("257")) {
			$parts = split(" ", $this->message);
			return preg_replace('/\"/',"", $parts[1]);
		}
		return "";
	}
	
	function is_ok() {
		$this->message = $this->sock_read();
		echo $this->message.'<br />';
		if($this->message == "" || preg_match('/^5/', $this->message)) return 0;
		else return 1;
	}
	
	function sock_write($s) {
		if ($s == "") echo "<-- cowardly refusing to write nothing -->";
		else {
			$this->log(">> $s");
			@fputs($this->sock, "$s\n");
		}
	}
	
	function dir_list($path="") {
		$s="";
		if ($this->pasv()) {
			if ($path == '') $this->sock_write("LIST");
			else $this->sock_write("LIST $path");
			
			if ($this->is_ok()) {
				while(true) {
					$line = fgets($this->data_sock);
					$s .= $line;
					if($line =='') break;
				}
			}
		}
		return $s;
	}
	
	function retr($path) {
		if ($this->pasv()) {
			$this->sock_write("RETR $path");
			if ($this->is_ok()) return $this->data_sock;
		}
		return "";
	}
	
	function stor($localPath, $remotePath) {
		log("<h3>uploading $localPath</h3>");
		if ($this->pasv()) {
			$this->sock_write("STOR $remotePath");
			if ($this->is_ok()) {
				$fp = fopen($localPath, "rb");
				if ($fp) {
					while(!feof($fp)) {
						$s = fread($fp, 4096);
						fwrite($this->data_sock, $s);
					}
					return 1;
				}
				return 0;
			}
		}
	}
	
	function pasv() {
		$this->sock_write("PASV");
		if ($this->is_ok()) {
			$offset = strpos($this->message,"(");
			
			$s = substr($this->message, ++$offset, strlen($this->messsage)-2);
			$parts = split(",", trim($s));
			$data_host = "$parts[0].$parts[1].$parts[2].$parts[3]";
			$data_port = ((int)$parts[4] << 8) + (int) $parts[5];
			
			$this->data_sock = fsockopen($data_host, $data_port, &$errno, &$errstr, 30);
			return $this->data_sock;
		}
		return "";
	}
	
	function login($user="", $pass="") {
		if($user=='') $user = $this->user;
		if($pass=='') $pass = $this->pass;
		
		$this->sock_write("USER $user");
		if ($this->is_ok()) {
			$this->sock_write("PASS $pass");
			if ($this->check_reply("230")) {
				return 1;
			}
		}
		
		ob_flush();
		return 0;
	}
	
	function check_reply($code) {
		if ($code=='230') {
			while (1) {
				if ($this->is_ok()) if( preg_match('/^230 /', $this->message)) return 1;
				else return 0;
			}
		} else {
			if ($this->is_ok()) {
				$pat = '/^'. $code .'/';
				if( preg_match($pat, $this->message)) return 1;
			}
			return 0;
		}
	}
	
	function rnfr($filename) {
		sock_write("RNFR $filename");
		if (is_ok()) return 1;
		else return 0;
	}
	
	function rnto($filename) {
		sock_write("RNTO $filename");
		if (is_ok()) return 1;
		else return 0;
	}
	
	function log($str) {
		if ($this->enable_log) echo "<!-- $str -->\n";
	}
	
	function set_user($user) {
		$this->user=$user;
	}
	
	function set_pass($pass){
		$this->pass =$pass;
	}
}
?>
