<?PHP
/*
  include/class.reports.php - 4/3/2009 - 8:32pm PST - 4.1.9
  
  SunShop Shopping Cart
  http://www.turnkeywebtools.com/sunshop/
  
  Copyright (c) 2001-2009 Turnkey Web Tools, Inc.
*/

if (!defined('SS_SESSION_START')) { die("Access denied"); }

class sreports {
	var $status1;
	var $status2;
	
	function sreports () {
		$this->status1 = get_data_array('status', 'name', 'dorder', "WHERE `type`='1'");
		$this->status2 = get_data_array('status', 'name', 'dorder', "WHERE `type`='2'");
		array_unshift($this->status1, 'All');
		array_unshift($this->status2, 'All');
	}
	
	function reset ($tab) {
		global $lang, $forms;
		return $lang['queryno'].$forms->start(array('url' => 'adminindex.php?action=transactions&sub=reports&tab='.$tab)).$forms->item("submit", "", "", "", "Reset", "", "", array('reset' => 0)).$forms->end();
	}
	
	function get_data ($date_start, $date_end, $order='All', $payment='All', $rsign=false) {
		global $DB_site, $dbprefix;
		
		$data = array();
		$data[orders] = 0;
		$data[date] = date("M", strtotime($date_start));
		
		if ($payment != 'All') $pstatus = " AND `cc_status`='".$payment."'";
		if ($order != 'All') $ostatus = " AND `status`='".$order."'";
		
		$query = $DB_site->query("SELECT * FROM `".$dbprefix."orders` WHERE `order_date` BETWEEN '".$date_start."' AND '".$date_end."'".$pstatus.$ostatus);
		while ($row = $DB_site->fetch_assoc($query)) {
			$data[orders] += 1;
			$add = array('subtotal', 'tax', 'discount', 'coupon_savings', 'gift_cert_savings', 'ship_price', 'rewards_savings', 'total');
			foreach ($add as $v) $data[$v] += $row[$v];
		}
		
		if ($data[orders] == 0) {
			$zero_out = array('subtotal', 'tax', 'discount', 'coupon_savings', 'gift_cert_savings', 'rewards_savings', 'ship_price', 'total');
			foreach ($zero_out as $v) $data[$v] = p(0, $rsign);
		} elseif ($rsign == true) {
			$add_sign = array('subtotal', 'tax', 'discount', 'coupon_savings', 'gift_cert_savings', 'rewards_savings', 'ship_price', 'total');
			foreach ($add_sign as $v) $data[$v] = p($data[$v], $rsign);
		}
		return $data;
	}
	
	function sales_year ($year='') {
		global $DB_site, $dbprefix;
		$year = ($year=="")?date("Y", stamp()):$year;
		$data = array();
		
		$months = array("01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12");
		foreach ($months as $m) {
			$date_start = $year.'-'.$m.'-01';
			$date_end 	= $year.'-'.$m.'-31';
			$data[$m] = $this->get_data($date_start, $date_end);
		}
		return $data;
	}
	
	function sales_bydate ($date_start, $date_end, $ship, $pay) {
		global $settings;
		$data = $this->get_data($date_start, $date_end, $ship, $pay, true);
		$data[start] = date($settings[datestamp], strtotime($date_start));
    	$data[end] = date($settings[datestamp], strtotime($date_end));
		return $data;
	}
    
	function sales_byitem ($date_start, $date_end, $order, $payment, $pid) {
		global $DB_site, $dbprefix, $settings;
		
		$info = get('products', $pid);
		
		$data = array();
		$data[orders] = 0;
		$data[item] = $info[title];
		
		$data[start] = date($settings[datestamp], strtotime($date_start));
    	$data[end] = date($settings[datestamp], strtotime($date_end));
		
		if ($payment != 'All') $pstatus = " AND `cc_status`='".$payment."'";
		if ($order != 'All') $ostatus = " AND `status`='".$order."'";
		
		$query1 = $DB_site->query("SELECT * FROM `".$dbprefix."orders` WHERE `order_date` BETWEEN '".$date_start."' AND '".$date_end."'".$pstatus.$ostatus);
		while ($row = $DB_site->fetch_assoc($query1)) {
			$ordercounts = 0;
			$query2 = $DB_site->query("SELECT * FROM `".$dbprefix."orders_products` WHERE `productid`='".$pid."' AND `orderid`='".$row[id]."'");
			while ($row2 = $DB_site->fetch_assoc($query2)) {
				$ordercounts = 1;
				$pdata = explode("\"", base64_decode($row2[data]));
				preg_match('/\:([0-9]+)\;/', $pdata[6], $qty);
				
				$data[quantity] += $qty[1];
				$data[total] 	+= ($row2[price] * $qty[1]);
			}
			if ($ordercounts == 1) $data[orders] += 1;
		}
		$data[total] = p($data[total], true, true);
		return $data;
	}
	
	function salesbyvm ($from='vendors', $date_start, $date_end, $order, $payment, $vmid) {
		global $DB_site, $dbprefix, $settings;
		
		$info = get($from, $vmid);
		
		$p_array = array('0');
		$data = array();
		$data[orders] = 0;
		$data[item] = ($from=='vendors')?$info[company]:$info[name];
		
		$data[start] = date($settings[datestamp], strtotime($date_start));
    	$data[end] = date($settings[datestamp], strtotime($date_end));
		
		if ($payment != 'All') $pstatus = " AND `cc_status`='".$payment."'";
		if ($order != 'All') $ostatus = " AND `status`='".$order."'";
		
		$query1 = $DB_site->query("SELECT `id` FROM 	`".$dbprefix."products` WHERE `".substr($from, 0, -1)."`='".$vmid."'");
		while ($row = $DB_site->fetch_assoc($query1)) array_push($p_array, $row[id]);
		
		$query2 = $DB_site->query("SELECT `id` FROM `".$dbprefix."orders` WHERE `order_date` BETWEEN '".$date_start."' AND '".$date_end."'".$pstatus.$ostatus);
        while($row2 = $DB_site->fetch_assoc($query2)) {
			$ordercounts = 0;
			$query3 = $DB_site->query("SELECT * FROM `".$dbprefix."orders_products` WHERE `orderid`='".$row2[id]."' AND `productid` IN (".implode(",", $p_array).")");
			while ($row3 = $DB_site->fetch_assoc($query3)) {
				$ordercounts = 1;
				$pdata = explode("\"", base64_decode($row3[data]));
				preg_match('/\:([0-9]+)\;/', $pdata[6], $qty);
				
				$data[quantity] += $qty[1];
				$data[total] 	+= ($row3[price] * $qty[1]);
			}
			if ($ordercounts == 1) $data[orders] += 1;
		}
		$data[total] = p($data[total], true, true);
		return $data;
	}
    
    function salesbycat ($date_start, $date_end, $order, $payment, $cid) {
		global $DB_site, $dbprefix, $settings;
		
		$info = get('categories', $cid);
		
		$p_array = array('0');
		$data = array();
		$data[orders] = 0;
		$data[item] = $info[title];
		
		$data[start] = date($settings[datestamp], strtotime($date_start));
    	$data[end] = date($settings[datestamp], strtotime($date_end));
		
		if ($payment != 'All') $pstatus = " AND `cc_status`='".$payment."'";
		if ($order != 'All') $ostatus = " AND `status`='".$order."'";
		
		$query = $DB_site->query("SELECT `productid` FROM `".$dbprefix."products_categories` WHERE `catid`='".$cid."'");
		while ($row = $DB_site->fetch_assoc($query)) array_push($p_array, $row[productid]);
		
		$query = $DB_site->query("SELECT `id` FROM `".$dbprefix."products` WHERE `catid`='".$cid."'");
		while ($row = $DB_site->fetch_assoc($query)) if (!in_array($row[id], $p_array)) array_push($p_array, $row[id]);
		
		$query = $DB_site->query("SELECT `id` FROM `".$dbprefix."orders` WHERE `order_date` BETWEEN '".$date_start."' AND '".$date_end."'".$pstatus.$ostatus);
        while($row = $DB_site->fetch_assoc($query)) {
			$ordercounts = 0;
			$query2 = $DB_site->query("SELECT * FROM `".$dbprefix."orders_products` WHERE `orderid`='".$row[id]."' AND `productid` IN (".implode(",", $p_array).")");
			while ($row2 = $DB_site->fetch_assoc($query2)) {
				$ordercounts = 1;
				$item = unserialize(base64_decode($row2[data]));
				$data[quantity] += $item->quantity;
				$data[total] 	+= ($row2[price] * $item->quantity);
			}
			if ($ordercounts == 1) $data[orders] += 1;
		}
		$data[total] = p($data[total], true, true);
		return $data;
    }
    
    function invoices ($date_start, $date_end, $order, $payment) {
		global $DB_site, $dbprefix;
		
		if ($payment != 'All') $pstatus = " AND `cc_status`='".$payment."'";
		if ($order != 'All') $ostatus = " AND `status`='".$order."'";
		
		$query = $DB_site->query("SELECT `id` FROM `".$dbprefix."orders` WHERE `order_date` BETWEEN '".$date_start."' AND '".$date_end."'".$pstatus.$ostatus);
		while ($row = $DB_site->fetch_assoc($query)) $this->invoice($row[id]);
    }
    
    function invoice ($order) {
		global $DB_site, $dbprefix, $settings;
		$info = get('orders', $order);
		
		$info[date] = date($settings[datestamp], $info[order_stamp]);
		$info[time] = date($settings[timestamp], $info[order_stamp]);
		
		$showbc = ($settings['showbc_print']=='Yes')?true:false;
		
		$info[hide] = array();
		$hides = array('userid', 'bill_company_name', 'bill_address2', 'ship_company_name', 'ship_address2', 'tax');
		foreach ($hides as $k => $v) {
			if ($info[$v] == "" || (p($info[$v]) == p(0.00) && is_numeric(str_replace('.', '', $info[$v]))))
				array_push($info[hide], $hides[$k]);
		}
		
		if (!$showbc) { array_push($info[hide], 'orderid_barcode'); array_push($info[hide], 'userid_barcode'); }
		else { $info[orderid_barcode] = urlencode($info[id]); $info[userid_barcode] = urlencode($info[userid]); }
		if ($info[userid]=='' || $info[userid]==0) array_push($info[hide], 'userid_barcode');
		
		$price = array('subtotal', 'discount', 'coupon_savings', 'ship_price', 'tax', 'gift_cert_savings', 'rewards_savings', 'total');
		foreach ($price as $k => $v) {
			$info[$v] = p($info[$v]);
			if (p(0) == $info[$v]) array_push($info[hide], $v);
		}
		
		$count = 1;
		$results = $DB_site->query("SELECT * FROM `".$dbprefix."orders_products` where `orderid`='".$order."' ORDER by `id`");
		while ($row = $DB_site->fetch_assoc($results)) {
			$prod = unserialize(base64_decode($row[item]));
			$item = new orderitem ($row[data]);
			
			$prod[count] = $count;
			$prod[hide] = array();
			$prod[options] = $item->display_options();
			$prod[quantity] = $item->get_quantity();
			$prod[price] = $row[price]+$item->options_price_increase();
			$prod[ptotal] = ($prod[quantity] * ($row[price]+$item->options_price_increase()));
			
			if (!$showbc) array_push($prod[hide], 'num_barcode');
			else $prod[num_barcode] = $prod[num];
			
			$price = array('price', 'ptotal');
			foreach ($price as $k => $v) {
				$prod[$v] = p($prod[$v]);
			}
			
			$info[items] .= template('packing_list_item.html', $prod);
			$count++;
		}
		
		$check = 'printorder';
		
		$results = $DB_site->query("SELECT * FROM `".$dbprefix."orders_custom_entries` e LEFT JOIN `".$dbprefix."orders_custom_fields` f on e.`fieldid`=f.`id` where e.`orderid`='".$order."' AND f.`".$check."`='y'");
		while ($field = $DB_site->fetch_assoc($results)) {
			$field = filter_data($field);
			$info[custom_fields_order] .= template('packing_list_custom_field_item.html', $field);
		}
		
		if ($info[custom_fields_order] == "") $info[hide][] = 'Custom Order Fields';
		
		$results = $DB_site->query("SELECT * FROM `".$dbprefix."users_custom_entries` e LEFT JOIN `".$dbprefix."users_custom_fields` f on e.`fieldid`=f.`id` where e.`orderid`='".$order."' AND f.`".$check."`='y'");
		while ($field = $DB_site->fetch_assoc($results)) {
			$field = filter_data($field);
			$info[custom_fields_user] .= template('packing_list_custom_field_item.html', $field);
		}
		
		$results = $DB_site->query("SELECT * FROM `".$dbprefix."users_custom_entries` e LEFT JOIN `".$dbprefix."users_custom_fields` f on e.`fieldid`=f.`id` where e.`userid`='".$info[userid]."' AND f.`".$check."`='y'");
		while ($field = $DB_site->fetch_assoc($results)) {
			$field = filter_data($field);
			$info[custom_fields_user] .= template('packing_list_custom_field_item.html', $field);
		}
		
		if ($info[custom_fields_user] == "") array_push($info[hide],'Custom Order Fields');
		
		$hide_empty = array('pm_name', 'pm_orderid', 'cc_name_on_card', 'cc_card_no', 'cc_card_type', 'cc_cvv2', 'cc_expir_date', 'cc_start_date', 'cc_issue_number', 'po_company', 'po_number', 'gift_cert', 'coupon', 'comments');
		foreach ($hide_empty as $k => $v) if ($info[$v] == "") array_push($info[hide], $v);
		
		if ($_POST[hashkey] == '') {			
			$info[cc_card_no] = $info[cc_card_no_lastfour];
			$info[cc_cvv2] = '';
		} else {
			$info[cc_card_no] = decryptit($info[cc_card_no]);
		}
		
		$info[style] = 'page-break-after: always;';
		
		echo template('packing_list.html', $info);
    }
}
?>