<?PHP
/*
  include/class.stats.php - 4/3/2009 - 8:32pm PST - 4.1.9
  
  SunShop Shopping Cart
  http://www.turnkeywebtools.com/sunshop/
  
  Copyright (c) 2001-2009 Turnkey Web Tools, Inc.
*/

if (!defined('SS_SESSION_START')) { die("Access denied"); }

class stats {
	var $rand = "123";
	
	function stats () {
		global $settings, $abs_path;
		$this->settings	= $settings;
		$this->dir_from = $abs_path;
		$this->rand 	= $settings[rand];
	}
	
	function store_report ($type, $value, $to, $from) {
		/* 
		#  = Type
		-----------------------------------
		1 = Unique IP - Broswer - OS
		2 = Unique Page Hits
		3 = Unique Referers
		-----------------------------------
		*/
		
		$datenow = date("Y-n-j");
		$timenow = date("h:i:s A");
		
		$system = @fopen($this->dir_from."/".ADMIN_DIR."/reports/".$datenow."_".$this->rand.".csv", "a");
		@fputs($system, "$type, $value, $to, $from, $timenow, $datenow\n");
		@fclose($system);
	}
	
	function parse_data ($newline) {
		$ret_array = array();
		if ($newline == "nofile") { return array(); }
		for ($i=0; $i<=count($newline); $i++) {
			$data = explode(",", $newline[$i]);
			$type 	= trim($data[0]); $value = trim($data[1]);
			$to 	= trim($data[2]); $from = trim($data[3]);
			switch ($type) {
			    case '':
					break;
				case 1:
					$split 	 = explode("-", $from);
					$ipaddr	 = $split[0];
					$browser = $split[1];
					$opsys 	 = $split[2];
					
					$key = md5($ipaddr);
					if (is_array($ret_array[visitors][$key])) {
						$ret_array[visitors][$key][hits] = $ret_array[visitors][$key][hits]+$value;
					} else {
						$ret_array[visitors][$key][hits] 		= $value;
						$ret_array[clients][browser][$browser]	= $ret_array[clients][browser][$browser]+1;
						$ret_array[clients][os][$opsys]  		= $ret_array[clients][os][$opsys]+1;
					}
					$ret_array[visitors][$key][value] = $ipaddr;
					break;
				case 2:
					$key = md5($from);
					$ret_array[pages][$key][value]	= $from;
					$ret_array[pages][$key][secure]	= $to;
					$ret_array[pages][$key][hits]	= (is_array($ret_array[pages][$key]))?$ret_array[pages][$key][hits]+$value:$value;
					
					$url = parse_url($from);
					if ($url[query] != "") {
						$ex	 = explode('&', $url[query]);
						foreach ($ex as $v) {
							$nv = explode('=', $v);
							$link[$nv[0]] = $nv[1];
						}
					} else {
						$link = array();
					}
					
					$from_a = array('&quot;', '&amp;', '&', '\'');
					$to_a	= array('', 'and', 'and', '`');
					
					switch ($link[l]) {
						case 'product_detail':
							$prod = get('products', $link[p]);
							if ($prod[title] == "") continue;
							$ret_array[products][$link[p]][name]	= shortenit(str_replace($from_a, $to_a, $prod[title]),25);
							$ret_array[products][$link[p]][hits]	= $ret_array[products][$link[p]][hits]+1;
							break;
						case 'product_list':
							$cat = get('categories', $link[c]);
							if ($cat[title] == "") continue;
							$ret_array[categories][$link[c]][name]	= shortenit(str_replace($from_a, $to_a, $cat[title]),25);
							$ret_array[categories][$link[c]][hits]	= $ret_array[categories][$link[c]][hits]+1;
							break;
						default:
							break;
					}
					
					break;
				case 3:
					$key = md5($from);
					$ret_array[referers][$key][value]	= $from;
					$ret_array[referers][$key][hits]	= (is_array($ret_array[referers][$key]))?$ret_array[referers][$key][hits]+$value:$value;
					break;
			}
		}
		return $ret_array;
	}
	
	function csv_read ($datenow, $ret_array=0) {
		$filename = $this->dir_from."/".ADMIN_DIR."/reports/".$datenow."_".$this->rand.".csv";
		if (!$fp = @fopen($filename, "r")) { return "nofile"; }
		$buffer = @fread($fp, @filesize($filename));
		@fclose ($fp);
		if ($ret_array == 1) $ret = @explode("\n", $buffer);
		else $ret = $buffer;
		return $ret;
	}
	
	function multi_csv_read ($yr, $mon) {
		global $dbprefix, $DB_site, $settings;
		$alldata = array();
		$days = date('t', strtotime($yr.'-'.$mon.'-01'));
		for ($i=1; $i<=$days; $i++) {
			$dat_array = $DB_site->query_first("SELECT * FROM `".$dbprefix."orders_stats_cache` where `date`='".date("Y-m-d", strtotime($yr."-".$mon."-".$i))."'");
			if ($dat_array[id] != "") {
				$stats = array('products', 'categories', 'referers', 'pages', 'clients', 'visitors');
				foreach ($stats as $v) $ret_array[$v] = unserialize(base64_decode(stripslashes($dat_array[$v])));
			} else {
				$newline = $this->csv_read(date("Y-n-j", strtotime($yr."-".$mon."-".$i)), 1);
				$ret_array = $this->parse_data($newline);
				if (strtotime($yr."-".$mon."-".$i) < strtotime(date("Y-n-j"))) {
					$DB_site->query("INSERT INTO `".$dbprefix."orders_stats_cache` set 
						`date`='".date("Y-m-d", strtotime($yr."-".$mon."-".$i))."', 
						`datestamp`='".strtotime($yr."-".$mon."-".$i)."',
						`products`='".addslashes(base64_encode(serialize($ret_array[products])))."',
						`categories`='".addslashes(base64_encode(serialize($ret_array[categories])))."',
						`referers`='".addslashes(base64_encode(serialize($ret_array[referers])))."',
						`pages`='".addslashes(base64_encode(serialize($ret_array[pages])))."',
						`visitors`='".addslashes(base64_encode(serialize($ret_array[visitors])))."',
						`clients`='".addslashes(base64_encode(serialize($ret_array[clients])))."'
					");
				}
			}
			
			foreach($ret_array as $k => $v) {
				if (is_array($v)) {
					foreach($v as $k1 => $v1) {
						switch ($k) {
							case 'products':
							case 'visitors':
							case 'pages':
							case 'referers':
							case 'categories':
								if (is_array($alldata[$k][$k1])) $alldata[$k][$k1][hits] += $v1[hits];
								else $alldata[$k][$k1] = $v1;
								break;
							case 'clients':
								foreach($v1 as $k2 => $v2) {
									if ($v2!="") $alldata[$k][$k1][$k2] += $v2;
									else $alldata[$k][$k1][$k2] = $v2;
								}
								break;
						}
					}
				}
			}
		}
		return $alldata;
	}
	
	function csv_to_array ($yr, $mon, $day) {
		global $dbprefix, $DB_site, $settings;
		$ret_array = array();
		if ($day=="") {
			$ret_array = $this->multi_csv_read($yr, $mon);
		} else {
			$dat_array = $DB_site->query_first("SELECT * FROM `".$dbprefix."orders_stats_cache` where `date`='".$yr."-".$mon."-".$day."'");
			if ($dat_array[id] != "") {
				$stats = array('products', 'categories', 'referers', 'pages', 'clients', 'visitors');
				foreach ($stats as $v) $ret_array[$v] = unserialize(base64_decode(stripslashes($dat_array[$v])));
			} else {
				$newline = $this->csv_read(date("Y-n-j", strtotime($yr."-".$mon."-".$day)), 1);
				$ret_array = $this->parse_data($newline);
				if (strtotime($yr."-".$mon."-".$day) < strtotime(date("Y-n-j"))) {
					$DB_site->query("INSERT INTO `".$dbprefix."orders_stats_cache` set 
						`date`='".$yr."-".$mon."-".$day."', 
						`datestamp`='".strtotime($yr."-".$mon."-".$day)."',
						`products`='".addslashes(base64_encode(serialize($ret_array[products])))."',
						`categories`='".addslashes(base64_encode(serialize($ret_array[categories])))."',
						`referers`='".addslashes(base64_encode(serialize($ret_array[referers])))."',
						`pages`='".addslashes(base64_encode(serialize($ret_array[pages])))."',
						`visitors`='".addslashes(base64_encode(serialize($ret_array[visitors])))."',
						`clients`='".addslashes(base64_encode(serialize($ret_array[clients])))."'
					");
				}
			}
		}
		return $ret_array;
	}
}
?>
