<?PHP
/*
  include/payment/2000charge.php - 4/3/2009 - 8:32pm PST - 4.1.9
  
  SunShop Shopping Cart
  http://www.turnkeywebtools.com/sunshop/
  
  Copyright (c) 2001-2009 Turnkey Web Tools, Inc.
*/

$ADDON_NAME 	= "2000Charge - DGL";
$ADDON_VERSION 	= "2.1";
$ADDON_TYPE 	= "Processor";
$CLASS_NAME 	= "twothousandcharge";

class twothousandcharge {
	var $class_vars;
	var $ctype;
	
	function twothousandcharge ($class_vars) {
		$this->class_vars = $class_vars;
	}
	
	function process () {
		global $cconnect, $sess;
		
		$userinfo	= $sess->gvar('userinfo');
		$orderinfo	= $sess->gvar('orderinfo');
		
		$oid = $sess->gvar('userid')."-".date("mdyHis");
		
		switch ($orderinfo[card_type]) { 
			case "VisaCard":	$this->ctype = "Visa";			break;
			case "MasterCard":	$this->ctype = "Mastercard";	break;
			case "JCB":			$this->ctype = "JCB";			break;
		}
		
		$data = array (
			'Account'			=> $this->class_vars[user],
			'Phone'				=> $userinfo[phone],
			'Address1'			=> urlencode($userinfo[bill_address1]),
			'Address2'			=> urlencode($userinfo[bill_address2]),
			'City'				=> $userinfo[bill_city],
			'State'				=> (($userinfo[bill_state]=='')?$userinfo[bill_other]:substr($userinfo[bill_state], 0, 2)),
			'Zip'				=> $userinfo[bill_zip],
			'Country'			=> $userinfo[bill_country],
			'Email'				=> $userinfo[email],
			'CCName'			=> $orderinfo[cc_name_on_card],
			'CCNum'				=> tempdecryptit($orderinfo[cc_card_no]),
			'CVV2'				=> $orderinfo[cc_cvv2],
			'CCExpireMonth'		=> $orderinfo[cc_expir_month],
			'CCExpireYear'		=> $orderinfo[cc_expir_year],
			'CCType'			=> $this->ctype,
			'Amount'			=> p($orderinfo[total], false),
			'RemoteHost'		=> $_SERVER['REMOTE_ADDR'],
			'UserDefineField'	=> $oid,
			'TrialFlag'			=> 0,
			'AddUser'			=> 0
		);
		
		foreach ($data as $k => $v) {
			$data_string .= $k.'='.$v.'&';
		}
		
		$header_array = array(
			"POST / HTTP/1.0",
		    "Content-type: application/x-www-form-urlencoded",
		    "Content-length: ".strlen($data_string)
		);
		
		$header = "POST / HTTP/1.0\r\n".
			"Content-Type: application/x-www-form-urlencoded\r\n".
			"Content-Length: " . strlen ($data_string) . "\r\n\r\n";
		
		$results = $cconnect->connect($data_string, $header, $header_array, $this->class_vars[url]);
		$authnet = $this->parse_return($results);
		
		$authnet["addon_message"] 	= ($authnet["resultmessage"]=="")?"Declined":$authnet["resultmessage"];
		$authnet["addon_code"]		= $authnet["errorcode"];
		$authnet["addon_oid"] 		= $oid;
		
		if ($authnet["resultcode"] == "Y") {
			$authnet["approved"] = "Approved";
		} else {
			$authnet["approved"] = "Error";
		}
		
		return $authnet;
	}
	
	function parse_return ($in) {
		$sep = explode("|", $in);
		$res = explode("=", $sep[0]);
		$out[resultcode] 	= $res[0];
		$out[errorcode]  	= $res[1];
		$out[resultmessage] = $sep[1];
		return $out;
	}
	
	function install () {
		global $DB_site, $dbprefix;
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='twothousandcharge', `internalname`='user', `name`='Username', `options`='', `value`='', `help`='Your username.', `size`='20', `dorder`='1', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='twothousandcharge', `internalname`='url', `name`='Transaction URL', `options`='', `value`='https://secure.2000Charge.com/secure/CCRemoteProcess.asp', `help`='Transaction url. Leave default if you are unsure.', `size`='60', `dorder`='2', `field_type`='textbox'");
	}
	
	function uninstall () {
		global $DB_site, $dbprefix;
		$DB_site->query("DELETE FROM ".$dbprefix."modules_payment where `module`='twothousandcharge'");
	}
}
?>
