<?PHP
/*
  include/payment/assist_modefour.php - 4/3/2009 - 8:32pm PST - 4.1.9
  
  SunShop Shopping Cart
  http://www.turnkeywebtools.com/sunshop/
  
  Copyright (c) 2001-2009 Turnkey Web Tools, Inc.
*/

$ADDON_NAME 	= "Assist (Mode 4)";
$ADDON_VERSION 	= "2.1";
$ADDON_TYPE 	= "Processor";
$CLASS_NAME 	= "assist_modefour";

class assist_modefour {
	var $class_vars;
	
	function assist_modefour ($class_vars) {
		$this->class_vars = $class_vars;
	}
	
	function process () {
		global $settings, $cconnect, $sess;
		
		$userinfo	= $sess->gvar('userinfo');
		$orderinfo	= $sess->gvar('orderinfo');
		
		$oid = $sess->gvar('userid')."-".date("mdyHis");
		
		$data = array (
			'Shop_IDP'		=> $this->class_vars[Shop_IDP],
			'Login'			=> $this->class_vars[Login],
			'Password'		=> $this->class_vars[Password],
			'FirstName'		=> $userinfo[bill_first_name],
			'LastName'		=> $userinfo[bill_last_name],
			'Phone'			=> $userinfo[phone],
			'Address'		=> urlencode($userinfo[bill_address1]),
			'City'			=> urlencode($userinfo[bill_city]),
			'State'			=> (($userinfo[bill_state]=='')?$userinfo[bill_other]:substr($userinfo[bill_state], 0, 2)),
			'Zip'			=> $userinfo[bill_zip],
			'Country'		=> $userinfo[bill_country],
			'Email'			=> $userinfo[email],
			'CardHolder'	=> urlencode($orderinfo[cc_name_on_card]),
			'CardType'		=> (($orderinfo[card_type]=="VisaCard")?"1":"").(($orderinfo[card_type]=="MasterCard")?"2":"").(($orderinfo[card_type]=="Diners")?"3":"").(($orderinfo[card_type]=="JCB")?"4":""),
			'CardNumber'	=> tempdecryptit($orderinfo[cc_card_no]),
			'CVC2'			=> $orderinfo[cc_cvv2],
			'ExpireMonth'	=> $orderinfo[cc_expir_month],
			'ExpireYear'	=> $orderinfo[cc_expir_year],
			'Subtotal_P'	=> p($orderinfo[total], false),
			'Order_IDP'		=> $oid,
			'Comment'		=> urlencode($settings[title]." Order Payment"),
			'ClientIP'		=> $_SERVER['REMOTE_ADDR'],
			'Format'		=> 3,
			'Delay'			=> 0,
			'DemoResult'	=> $this->class_vars[testmode],
			'Language'		=> (($userinfo[bill_country]=="RU")?"0":"1"),
			'Currency'		=> $settings[defaultrate]
		);
		
		foreach ($data as $k => $v) {
			$data_string .= $k.'='.$v.'&';
		}
		
		$header_array = array(
			"POST / HTTP/1.0",
		    "Content-type: application/x-www-form-urlencoded",
		    "Content-length: ".strlen($data_string)
		);
		
		$header = "POST / HTTP/1.0\r\n".
			"Content-Type: application/x-www-form-urlencoded\r\n".
			"Content-Length: " . strlen ($data_string) . "\r\n\r\n";
		
		$results = $cconnect->connect($data_string, $header, $header_array, $this->class_vars[authurl]);
		
		$auth = $this->parse_return($results);
		
		$authret["addon_message"] 	= $auth["recommendation"];
		$authret["addon_code"]		= $auth["response_code"];
		$authret["addon_oid"] 		= $auth["billnumber"];
		
		if ($auth["status"] == "Authorized") {
			$authret["approved"] = "Approved";
		} else {
			$authret["approved"] = "Error";
		}
		
		return $authret;
	}
	
	function parse_return ($in) {
		$out = parse_xml($in);
		return $out[assistresult][orders][order];
	}
	
	function install () {
		global $DB_site, $dbprefix;
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='assist_modefour', `internalname`='Shop_IDP', `name`='Shop Assist IDP', `options`='', `value`='', `help`='Your Assist IDP', `size`='20', `dorder`='1', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='assist_modefour', `internalname`='Login', `name`='Your Assist Login', `options`='', `value`='', `help`='Your Assist Login', `size`='20', `dorder`='2', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='assist_modefour', `internalname`='Password', `name`='Your Assist Password', `options`='', `value`='', `help`='Your Assist Password', `size`='20', `dorder`='3', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='assist_modefour', `internalname`='authurl', `name`='Transaction URL', `options`='', `value`='https://secure.assist.ru/smode/4mode.cfm', `help`='Assist transaction url. Leave default if you are unsure.', `size`='60', `dorder`='4', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='assist_modefour', `internalname`='testmode', `name`='Test Mode', `options`='Live::AS000::AS100->Live::Test (Approve)::Test (Decline)', `value`='AS000', `help`='Assist test mode status. Set to false to go live.', `size`='0', `dorder`='6', `field_type`='dropdown'");
	}
	
	function uninstall () {
		global $DB_site, $dbprefix;
		$DB_site->query("DELETE FROM ".$dbprefix."modules_payment where `module`='assist_modefour'");
	}
}
?>