<?PHP
/*
  include/payment/directone.php - 4/3/2009 - 8:32pm PST - 4.1.9
  
  SunShop Shopping Cart
  http://www.turnkeywebtools.com/sunshop/
  
  Copyright (c) 2001-2009 Turnkey Web Tools, Inc.
*/

$ADDON_NAME 	= "DirectOne";
$ADDON_VERSION 	= "1.1";
$ADDON_TYPE 	= "Processor";
$CLASS_NAME 	= "directone";

class directone {
	var $class_vars;
	var $summary_codes;
	
	function directone ($class_vars) {
		$this->class_vars = $class_vars;
		$this->summary_codes = array(
			"0" => "Transaction Successful",
			"1" => "Transaction Declined",
			"2" => "Transaction Declined",
			"3" => "System Error"
		);
	}
	
	function process () {
		global $cconnect, $sess;
		
		$userinfo	= $sess->gvar('userinfo');
		$orderinfo	= $sess->gvar('orderinfo');
		
		$oid = $sess->gvar('userid')."-".date("mdyHis");
		
		$param = array (
			'vendor_name' 		=> $this->class_vars[merchantid],
			'vendor_password' 	=> $this->class_vars[merchantpass],
			
			'card_holder'		=> $orderinfo[cc_name_on_card],
			'card_number' 		=> tempdecryptit($orderinfo[cc_card_no]),
			'card_type'			=> 'AUTO',
			'card_cvv' 			=> $orderinfo[cc_cvv2],
			'card_expiry' 		=> str_pad($orderinfo[cc_expir_month], 2, "0", STR_PAD_LEFT).substr($orderinfo[cc_expir_year], -2, 2),
			'card_expiry_month'	=> str_pad($orderinfo[cc_expir_month], 2, "0", STR_PAD_LEFT),
			'card_expiry_year'	=> substr($orderinfo[cc_expir_year], -2, 2),
			'payment_amount' 	=> p($orderinfo[total], false),
			'payment_date'		=> date("m/d/Y"),
			'payment_reference'	=> '',
			'remote_ip'			=> $_SERVER['REMOTE_ADDR']
		);
		
		//debug($param);
		
		$header_array = array();
		$header = "";
		
		foreach($param as $k => $v ) {
			$data .= $k."=".$v."&";
		}
		
		$results = $cconnect->connect($data, $header, $header_array, 'https://vault.safepay.com.au:443/cgi-bin/direct_'.($this->class_vars["testmode"]=='Y'?'test':'process').'.pl');
		$auth = $this->parse_return($results);
		
		$auth["addon_message"] 	= $this->summary_codes[$auth["summary_code"]];
		$auth["addon_code"]		= $auth["summary_code"];
		$auth["addon_oid"] 		= $auth["payment_number"];
		
		if ($auth["summary_code"] == "0" && $auth[payment_number] != "") {
			$auth["approved"] = "Approved";
		} else {
			$auth["approved"] = "Error";
		}
		
		return $auth;
	}
	
	function parse_return ($in) {
		global $DB_site;
		$array = explode("\n", str_replace("\"", "", $in));
		foreach ($array as $v) {
			$sep = explode('=', $v);
			$out[$sep[0]] = $sep[1];
		}
		return $out;
	}
	
	function install () {
		global $DB_site, $dbprefix;
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='directone', `internalname`='merchantid', `name`='Merchant User/ID', `options`='', `value`='', `help`='Your Merchant Username/ID.', `size`='20', `dorder`='1', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='directone', `internalname`='merchantpass', `name`='Merchant Password', `options`='', `value`='', `help`='Your Password.', `size`='20', `dorder`='2', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='directone', `internalname`='testmode', `name`='Test Mode', `options`='Y::N->True::False', `value`='N', `help`='Test mode status. Set to false to go live.', `size`='0', `dorder`='3', `field_type`='dropdown'");
	}
	
	function uninstall () {
		global $DB_site, $dbprefix;
		$DB_site->query("DELETE FROM ".$dbprefix."modules_payment where `module`='directone'");
	}
}
?>