<?PHP
/*
  include/payment/eps_securenet.php - 4/3/2009 - 8:32pm PST - 4.1.9
  
  SunShop Shopping Cart
  http://www.turnkeywebtools.com/sunshop/
  
  Copyright (c) 2001-2009 Turnkey Web Tools, Inc.
*/

$ADDON_NAME 	= "EPS Securenet";
$ADDON_VERSION 	= "2.1";
$ADDON_TYPE 	= "Processor";
$CLASS_NAME 	= "eps_securenet";

class eps_securenet {
	var $class_vars;
	
	function eps_securenet ($class_vars) {
		$this->class_vars = $class_vars;
	}
	
	function process () {
		global $cconnect, $sess;
		
		$userinfo	= $sess->gvar('userinfo');
		$orderinfo	= $sess->gvar('orderinfo');
		
		$data = array (
			'IDNum'	=> $this->class_vars[authuser],
			'responseMeth'		=> 'STRING',
			'str_delim_encap'	=> '',
			'str_delim_char'	=> ',',
			'TranType'			=> 'SALE',
			
			'Bill_Phone'		=> $userinfo[phone],
			'AddressLine1'		=> $userinfo[bill_address1],
			'AddressLine2'		=> $userinfo[bill_address2],
			'Bill_City'			=> $userinfo[bill_city],
			'Bill_State'		=> (($userinfo[bill_state]=='')?$userinfo[bill_other]:substr($userinfo[bill_state], 0, 2)),
			'ZipCode'			=> $userinfo[bill_zip],
			'Bill_Country'		=> $userinfo[bill_country],
			'Bill_Email'		=> $userinfo[email],
			
			'CardHolderName'	=> $orderinfo[cc_name_on_card],
			'CardNumber'		=> tempdecryptit($orderinfo[cc_card_no]),
			'CVV2Code'			=> $orderinfo[cc_cvv2],
			'ExpiryDate'		=> $orderinfo[cc_expir_month].substr($orderinfo[cc_expir_year], 2, 2),
			
			'TranAmount'		=> p($orderinfo[total], false),
			'TaxAmount'			=> $orderinfo[tax],
			'ShipCost'			=> $orderinfo[ship_price],
			'InvoiceNbr'		=> $orderinfo[invoiceid],
			
			'Ship_Name'			=> $userinfo[ship_first_name]."%20".$userinfo[ship_last_name],
			'Ship_Address1'		=> $userinfo[ship_address1],
			'Ship_Address2'		=> $userinfo[ship_address2],
			'Ship_City'			=> $userinfo[ship_city],
			'Ship_State'		=> (($userinfo[ship_state]=='')?$userinfo[shipl_other]:substr($userinfo[ship_state], 0, 2)),
			'Ship_ZipCode'		=> $userinfo[ship_zip],
			'Ship_Country'		=> $userinfo[ship_country]
		);
		
		foreach ($data as $k => $v) {
			$data_string .= $k.'='.$v.'&';
		}
		
		$header_array = array(
			"POST / HTTP/1.0",
		    "Content-type: application/x-www-form-urlencoded",
		    "Content-length: ".strlen($data_string)
		);
		
		$header = "POST / HTTP/1.0\r\n".
			"Content-Type: application/x-www-form-urlencoded\r\n".
			"Content-Length: " . strlen ($data_string) . "\r\n\r\n";
		
		$results = $cconnect->connect($data_string, $header, $header_array, $this->class_vars[authurl]);
		$auth	 = $this->parse_return($results);
		
		$auth["addon_message"] 	= $auth["RespMessage"].$auth["ErrorMsg"];
		$auth["addon_code"]		= $auth["ErrorNum"];
		$auth["addon_oid"] 		= $auth["ReferenceNbr"];
		
		if ($auth["ReturnCodeRaw"] == 0) {
			$auth["approved"] = "Approved";
		} else {
			$auth["approved"] = "Error";
		}
		
		return $auth;
	}
	
	function parse_return ($in) {
		$remaining 	= str_replace("\"", "", trim($in));
		$auth_array	= explode(",", $remaining);
		$out = array(
			"ReturnCode"	=> "$auth_array[0]",
			"ReturnCodeRaw"	=> "$auth_array[1]",
			"ApprovalCode"	=> "$auth_array[2]",
			"AVSResult"		=> "$auth_array[3]",
			"CVV2Result"	=> "$auth_array[4]",
			"RespMessage"	=> "$auth_array[5]",
			"TranDateRaw"	=> "$auth_array[6]",
			"TranTimeRaw"	=> "$auth_array[7]",
			"ReferenceNbr"	=> "$auth_array[8]",
			"BatchID"		=> "$auth_array[9]",
			"ErrorMsg"		=> "$auth_array[10]",
			"ErrorNum"		=> "$auth_array[11]"
		);
		
		return $out;
	}
	
	function install () {
		global $DB_site, $dbprefix;
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='eps_securenet', `internalname`='authuser', `name`='Merchant Login', `options`='', `value`='', `help`='Your assigned merchant login ID.', `size`='0', `dorder`='1', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='eps_securenet', `internalname`='authurl', `name`='Transaction URL', `options`='', `value`='https://www.epssecurenet.com/egate/api_securegate.php', `help`='Transaction url. Leave default unless necessary.', `size`='60', `dorder`='2', `field_type`='textbox'");
	}
	
	function uninstall () {
		global $DB_site, $dbprefix;
		$DB_site->query("DELETE FROM ".$dbprefix."modules_payment where `module`='eps_securenet'");
	}
}
?>
