<?PHP
/*
  include/payment/net1gateway.php - 4/3/2009 - 8:32pm PST - 4.1.9
  
  SunShop Shopping Cart
  http://www.turnkeywebtools.com/sunshop/
  
  Copyright (c) 2001-2009 Turnkey Web Tools, Inc.
*/

$ADDON_NAME 	= "NET1 Gateway";
$ADDON_VERSION 	= "2.1";
$ADDON_TYPE 	= "Processor";
$CLASS_NAME 	= "net1gateway";

class net1gateway {
	var $class_vars;
	
	function net1gateway ($class_vars) {
		$this->class_vars = $class_vars;
	}
	
	function process () {
		global $cconnect, $sess;
		
		$userinfo	= $sess->gvar('userinfo');
		$orderinfo	= $sess->gvar('orderinfo');
		
		$data = array (
			'M_id'				=> $this->class_vars[userid],
			'M_key'				=> $this->class_vars[user_key],
			
			'C_address'			=> $userinfo[bill_address1],
			'C_city'			=> $userinfo[bill_city],
			'C_state'			=> (($userinfo[bill_state]=='')?$userinfo[bill_other]:substr($userinfo[bill_state], 0, 2)),
			'C_zip'				=> $userinfo[bill_zip],
			'C_country'			=> $userinfo[bill_country],
			'C_email'			=> $userinfo[email],
			
			'C_address'			=> $userinfo[ship_address1],
			'C_city'			=> $userinfo[ship_city],
			'C_state'			=> (($userinfo[ship_state]=='')?$userinfo[shipl_other]:substr($userinfo[ship_state], 0, 2)),
			'C_zip'				=> $userinfo[ship_zip],
			'C_country'			=> $userinfo[ship_country],
			'C_telephone'		=> $userinfo[phone],
			
			'C_name'			=> $orderinfo[cc_name_on_card],
			'C_cardnumber'		=> tempdecryptit($orderinfo[cc_card_no]),
			'C_cvv'				=> $orderinfo[cc_cvv2],
			'C_exp'				=> str_pad($orderinfo[cc_expir_month], 2, "0", STR_PAD_LEFT).substr($orderinfo[cc_expir_year], 2, 2),
			
			'T_amt'				=> p($orderinfo[total], false),
			'T_code'			=> '01',
			'T_customer_number'	=> $sess->gvar('userid'),
			'T_ordernum'		=> $orderinfo[orderid],
		);
		
		foreach ($data as $k => $v) {
			$data_string .= $k.'='.$v.'&';
		}
		
		$header_array = array(
			"POST / HTTP/1.0",
		    "Content-type: application/x-www-form-urlencoded",
		    "Content-length: ".strlen($data_string)
		);
		
		$header = "POST / HTTP/1.0\r\n".
			"Content-Type: application/x-www-form-urlencoded\r\n".
			"Content-Length: " . strlen ($data_string) . "\r\n\r\n";
		
		$results = $cconnect->connect($data_string, $header, $header_array, $this->class_vars[url]);
		$result	 = $this->parse_return($results);
		
		$auth["addon_message"] 	= $result["message"];
		$auth["addon_code"]		= $result["code"];
		$auth["addon_oid"] 		= $result["ordernum"];
		
		if ($result["approval_code"] == "A") {
			$auth["approved"] = "Approved";
		} else {
			$auth["approved"] = "Error";
		}
		
		return $auth;
	}
	
	function parse_return ($in) {
		$auth_results[approval_code] 	= substr($in, 1, 1); 
		$auth_results[code] 			= substr($in, 2, 6);
		$auth_results[message] 			= substr($in, 8, 32);
		$auth_results[cvv2_code] 		= substr($in, 42, 1);
		$auth_results[avs_code] 		= substr($in, 43, 1);
		$auth_results[risk_code] 		= substr($in, 44, 1);
		$auth_results[reference] 		= substr($in, 46, 10);
		$auth_results[seperator] 		= substr($in, 56, 1);
		
		$rest  = substr($in, 57);
		$split = explode($auth_results[seperator], $rest);
		
		$auth_results[ordernum] 		= $split[0];
		$auth_results[rec_indicator] 	= $split[1];
		$auth_results[etx] 				= $split[2];
		
		return $auth_results;
	}
	
	function install () {
		global $DB_site, $dbprefix;
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='net1gateway', `internalname`='userid', `name`='User ID', `options`='', `value`='', `help`='Your assigned merchant user ID.', `size`='0', `dorder`='1', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='net1gateway', `internalname`='user_key', `name`='User Key', `options`='', `value`='', `help`='Your assigned user key.', `size`='0', `dorder`='2', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='net1gateway', `internalname`='url', `name`='Transaction URL', `options`='', `value`='https://va.eftsecure.net/cgi-bin/eftBankcard.dll?transaction', `help`='Transaction url. Leave to default if unless needed.', `size`='60', `dorder`='3', `field_type`='textbox'");
	}
	
	function uninstall () {
		global $DB_site, $dbprefix;
		$DB_site->query("DELETE FROM ".$dbprefix."modules_payment where `module`='net1gateway'");
	}
}
?>
