<?PHP
/*
  include/payment/realex_realauth.php - 4/3/2009 - 8:32pm PST - 4.1.9
  
  SunShop Shopping Cart
  http://www.turnkeywebtools.com/sunshop/
  
  Copyright (c) 2001-2009 Turnkey Web Tools, Inc.
*/

$ADDON_NAME 	= "Realex Realauth (Remote)";
$ADDON_VERSION 	= "1.0";
$ADDON_TYPE 	= "Processor";
$CLASS_NAME 	= "realex_realauth";

class realex_realauth {
	var $class_vars;
	
	function realex_realauth ($class_vars) {
		$this->class_vars = $class_vars;
	}
	
	function process () {
		global $settings, $cconnect, $sess;
		
		$userinfo	= $sess->gvar('userinfo');
		$orderinfo	= $sess->gvar('orderinfo');
		
		//Creates timestamp that is needed to make up orderid
		$timestamp = strftime("%Y%m%d%H%M%S");
		mt_srand((double)microtime()*1000000);
		
		//You can use any alphanumeric combination for the orderid.Although each transaction must have a unique orderid.
		$orderid = $timestamp."-".mt_rand(1, 999);
		
		// This section of code creates the md5hash that is needed
		$tmp = "$timestamp.".$this->class_vars[merchantid].".$orderid.".str_replace(".","",p($orderinfo[total], false)).".".$settings[defaultrate].".".tempdecryptit($orderinfo[cc_card_no]);
		$md5hash = md5($tmp);
		$tmp = "$md5hash.".$this->class_vars[secret];
		$md5hash = md5($tmp);
		
		switch ($orderinfo[cc_card_type]) {
			case 'Mastercard':
				$pp_type = 'MC';
				break;
			case 'American Express':
				$pp_type = 'Amex';
				break;
			default:
				$pp_type = $orderinfo[cc_card_type];
				break;
		}
		
		$xml = "<request type='auth' timestamp='$timestamp'>
			<merchantid>".$this->class_vars[merchantid]."</merchantid>
			<account>".$this->class_vars[account]."</account>
			<orderid>$orderid</orderid>
			<amount currency='".$settings[defaultrate]."'>".str_replace(".","",p($orderinfo[total], false))."</amount>
			<card> 
				<number>".tempdecryptit($orderinfo[cc_card_no])."</number>
				<expdate>".$orderinfo[cc_expir_month].substr($orderinfo[cc_expir_year], 0, 2)."</expdate>
				<type>".$pp_type."</type> 
				<chname>".$orderinfo[cc_name_on_card]."</chname> 
			</card> 
			<autosettle flag='1'/>
			<md5hash>$md5hash</md5hash>
			<tssinfo>
				<address type=\"billing\">
					<country>".strtolower($userinfo[bill_country])."</country>
				</address>
			</tssinfo>
		</request>";
		
		$header_array = array(
			"POST / HTTP/1.0",
		    "Content-type: application/x-www-form-urlencoded",
		    "Content-length: ".strlen($xml)
		);
		
		$header = "POST / HTTP/1.0\r\n".
			"Content-Type: application/x-www-form-urlencoded\r\n".
			"Content-Length: " . strlen ($xml) . "\r\n\r\n";
		
		$results = $cconnect->connect($xml, $header, $header_array, $this->class_vars[url]);
		$auth	 = $this->parse_return($results);
		
		$auth["addon_message"] 	= $auth["message"];
		$auth["addon_code"]		= $auth["result"];
		$auth["addon_oid"] 		= $auth["orderid"];
		
		if ($auth["result"] == '00') {
			$auth["approved"] = "Approved";
		} else {
			$auth["approved"] = "Error";
		}
		
		return $auth;
	}
	
	function parse_return ($in) {
		$attributes = array();
	    $attributes = XMLParser($in);
		
	    reset($attributes);
		while (list ($key, $val) = each ($attributes)) {
			$name = $val['tag']; $value = $val['value'];
			$out[$name] = $value;
		}
		return $out;
	}
	
	function install () {
		global $DB_site, $dbprefix;
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='realex_realauth', `internalname`='merchantid', `name`='Merchant ID', `options`='', `value`='', `help`='Your assigned merchant ID.', `size`='20', `dorder`='1', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='realex_realauth', `internalname`='Account', `name`='Account', `options`='', `value`='', `help`='Your assigned sub account.', `size`='20', `dorder`='2', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='realex_realauth', `internalname`='secret', `name`='Secret', `options`='', `value`='', `help`='Your secret phrase.', `size`='20', `dorder`='3', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='realex_realauth', `internalname`='url', `name`='Transaction URL', `options`='', `value`='https://epage.payandshop.com/epage-remote.cgi', `help`='Transaction url. Leave default if you are unsure.', `size`='60', `dorder`='4', `field_type`='textbox'");
	}
	
	function uninstall () {
		global $DB_site, $dbprefix;
		$DB_site->query("DELETE FROM ".$dbprefix."modules_payment where `module`='realex_realauth'");
	}
}
?>