<?PHP
/*
  include/payment/rtware_adc.php - 4/3/2009 - 8:32pm PST - 4.1.9
  
  SunShop Shopping Cart
  http://www.turnkeywebtools.com/sunshop/
  
  Copyright (c) 2001-2009 Turnkey Web Tools, Inc.
*/

$ADDON_NAME 	= "RTWare ADC";
$ADDON_VERSION 	= "2.1";
$ADDON_TYPE 	= "Processor";
$CLASS_NAME 	= "rtware_adc";

class rtware_adc {
	var $class_vars;
	
	function rtware_adc ($class_vars) {
		$this->class_vars = $class_vars;
	}
	
	function process () {
		global $cconnect, $settings, $sess;
		
		$userinfo	= $sess->gvar('userinfo');
		$orderinfo	= $sess->gvar('orderinfo');
		
		$oid = $sess->gvar('userid')."-".date("mdyHis");
		
		/**** Login Information ****/
		$data = "x_Login=".$this->class_vars[authuser]."&";
		$data .= "x_Password=".$this->class_vars[authkey]."&";
		
		/**** Contact Information ****/
		$data .= "x_First_Name=".$userinfo[bill_first_name]."&";
		$data .= "x_Last_Name=".$userinfo[bill_last_name]."&";
		$data .= "x_Phone=".$userinfo[phone]."&";
		$data .= "x_Address=".urlencode($userinfo[bill_address1])."&";
		$data .= "x_City=".$userinfo[bill_city]."&";
		$data .= "x_State=".(($userinfo[bill_state]=='')?$userinfo[bill_other]:substr($userinfo[bill_state], 0, 2))."&";
		$data .= "x_Zip=".$userinfo[bill_zip]."&";
		$data .= "x_Country=".$userinfo[bill_country]."&";
		$data .= "x_Email=".$userinfo[email]."&";
		
		/**** Credit Card Information ****/ 
		$data .= "x_Card_Num=".tempdecryptit($orderinfo[cc_card_no])."&";
		$data .= "x_card_code=".$orderinfo[cc_cvv2]."&";
		$data .= "x_Exp_Date=".$orderinfo[cc_expir_month].$orderinfo[cc_expir_year]."&";
		
		/**** Order Information ****/
		$data .= "x_Amount=".p($orderinfo[total], false)."&";
		$data .= "x_Tax=0.00&";
		$data .= "x_Freight=0.00&";
		$data .= "x_Cust_ID=".$sess->gvar('userid')."&";
		$data .= "x_Invoice_Num=".$oid."&";
		$data .= "x_Description=".urlencode($settings[title])."%20Order%20Payment&";
		$data .= "x_Trans_ID=".$oid."&";
		$data .= "x_customer_IP=".$_SERVER['REMOTE_ADDR']."&";
		
		/**** Shipping Information ****/ 
		$data .= "x_Ship_To_First_Name=".$userinfo[ship_first_name]."&";
		$data .= "x_Ship_To_Last_Name=".$userinfo[ship_last_name]."&";
		$data .= "x_Ship_To_Address=".urlencode($userinfo[ship_address1])."&";
		$data .= "x_Ship_To_City=".$userinfo[ship_city]."&";
		$data .= "x_Ship_To_State=".(($userinfo[ship_state]=='')?$userinfo[shipl_other]:substr($userinfo[ship_state], 0, 2))."&";
		$data .= "x_Ship_To_Zip=".$userinfo[ship_zip]."&";
		$data .= "x_Ship_To_Country=".$userinfo[ship_country]."&";
		
		/**** Configuration Defaults ****/ 
		$data .= "x_ADC_Delim_Data=true&";
		$data .= "x_ADC_Delim_Character=,&";
		$data .= "x_ADC_Encapsulate_Character=&";
		$data .= "x_ADC_URL=false&";
		$data .= "x_Version=3.0&";
		$data .= "x_Method=CC&";
		$data .= "x_Type=auth_capture&";
		$data .= "x_Email_Customer=True&";
		$data .= "x_Test_Request=".$this->class_vars[testmode];
		
		$header_array = array(
			"POST / HTTP/1.0",
		    "Content-type: application/x-www-form-urlencoded",
		    "Content-length: ".strlen($data)
		);
		
		$header = "POST / HTTP/1.0\r\n".
			"Content-Type: application/x-www-form-urlencoded\r\n".
			"Content-Length: " . strlen ($data) . "\r\n\r\n";
		
		$results = $cconnect->connect($data, $header, $header_array, $this->class_vars[authurl]);
		$authnet = $this->parse_return($results);
		
		$authnet["addon_message"] 	= $authnet["x_response_reason_text"];
		$authnet["addon_code"]		= $authnet["x_response_reason_code"];
		$authnet["addon_oid"] 		= $authnet["x_trans_id"];
		
		if ($authnet["x_response_code"] == 1) {
			$authnet["approved"] = "Approved";
		} else {
			$authnet["approved"] = "Error";
		}
		
		return $authnet;
	}
	
	function parse_return ($in) {
		$authnet_array = explode(",", str_replace("\"", "", $in));
		$out = array(
			"x_response_code"			=> "$authnet_array[0]",
			"x_response_subcode"		=> "$authnet_array[1]",
			"x_response_reason_code"	=> "$authnet_array[2]",
			"x_response_reason_text"	=> "$authnet_array[3]",
			"x_auth_code"				=> "$authnet_array[4]",
			"x_avs_code"				=> "$authnet_array[5]",
			"x_trans_id"				=> "$authnet_array[6]",
			"x_invoice_num"				=> "$authnet_array[7]",
			"x_description"				=> "$authnet_array[8]",
			"x_amount"					=> "$authnet_array[9]",
			"x_method"					=> "$authnet_array[10]",
			"x_type"					=> "$authnet_array[11]",
			"x_cust_id"					=> "$authnet_array[12]",
			"x_first_name"				=> "$authnet_array[13]",
			"x_last_name"				=> "$authnet_array[14]",
			"x_company"					=> "$authnet_array[15]",
			"x_address"					=> "$authnet_array[16]",
			"x_city"					=> "$authnet_array[17]",
			"x_state"					=> "$authnet_array[18]",
			"x_zip"						=> "$authnet_array[19]",
			"x_country"					=> "$authnet_array[20]",
			"x_phone"					=> "$authnet_array[21]",
			"x_fax"						=> "$authnet_array[22]",
			"x_email"					=> "$authnet_array[23]",
			"x_ship_to_first_name"		=> "$authnet_array[24]",
			"x_ship_to_last_name"		=> "$authnet_array[25]",
			"x_ship_to_company"			=> "$authnet_array[26]",
			"x_ship_to_address"			=> "$authnet_array[27]",
			"x_ship_to_city"			=> "$authnet_array[28]",
			"x_ship_to_state"			=> "$authnet_array[29]",
			"x_ship_to_zip"				=> "$authnet_array[30]",
			"x_ship_to_country"			=> "$authnet_array[31]",
			"x_tax"						=> "$authnet_array[32]",
			"x_duty"					=> "$authnet_array[33]",
			"x_freight"					=> "$authnet_array[34]",
			"x_tax_exempt"				=> "$authnet_array[35]",
			"x_po_num"					=> "$authnet_array[36]",
			"x_md5_hash"				=> "$authnet_array[37]",
			"x_cvv2_resp_code"			=> "$authnet_array[38]"
		);
		
		return $out;
	}
	
	function install () {
		global $DB_site, $dbprefix;
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='rtware_adc', `internalname`='authuser', `name`='Username', `options`='', `value`='', `help`='Your RTWare username.', `size`='20', `dorder`='1', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='rtware_adc', `internalname`='authkey', `name`='Password', `options`='', `value`='', `help`='Your RTWare password or transaction key.', `size`='20', `dorder`='2', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='rtware_adc', `internalname`='authurl', `name`='Transaction URL', `options`='', `value`='https://secure.RTWare.net/gateway/transact.dll', `help`='RTWare transaction url. Leave default if you are unsure.', `size`='60', `dorder`='3', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='rtware_adc', `internalname`='testmode', `name`='Test Mode', `options`='True::False->True::False', `value`='', `help`='RTWare test mode status. Set to false to go live.', `size`='0', `dorder`='4', `field_type`='dropdown'");
	}
	
	function uninstall () {
		global $DB_site, $dbprefix;
		$DB_site->query("DELETE FROM ".$dbprefix."modules_payment where `module`='rtware_adc'");
	}
}
?>
