<?PHP
/*
  include/payment/securepay_xml.php - 4/3/2009 - 8:32pm PST - 4.1.9
  
  SunShop Shopping Cart
  http://www.turnkeywebtools.com/sunshop/
  
  Copyright (c) 2001-2009 Turnkey Web Tools, Inc.
*/

$ADDON_NAME 	= "SecurePay XML";
$ADDON_VERSION 	= "1.0";
$ADDON_TYPE 	= "Processor";
$CLASS_NAME 	= "securepay_xml";

class securepay_xml {
	var $class_vars;
	
	function securepay_xml ($class_vars) {
		$this->class_vars = $class_vars;
	}
	
	function process () {
		global $cconnect, $sess, $settings;
		
		$userinfo	= $sess->gvar('userinfo');
		$orderinfo	= $sess->gvar('orderinfo');
		
		$oid 	= $sess->gvar('userid').'-'.date("mdyHis");
		$stamp 	= date("YmdGis")."000+1000";
		
		$data = '<?xml version="1.0" encoding="UTF-8"?>
			<SecurePayMessage>
				<MessageInfo>
					<messageID>'.substr(md5($stamp), -30, 30).'</messageID>
					<messageTimestamp>'.$stamp.'</messageTimestamp>
					<timeoutValue>60</timeoutValue>
					<apiVersion>xml-4.2</apiVersion>
				</MessageInfo>
				<MerchantInfo>
					<merchantID>'.$this->class_vars[merchantid].'</merchantID>
					<password>'.$this->class_vars[merchantpass].'</password>
				</MerchantInfo>
				<RequestType>Payment</RequestType>
				<Payment>
					<TxnList count="1">
						<Txn ID="1">
							<txnType>0</txnType>
							<txnSource>23</txnSource>
							<amount>'.str_replace(".", "", p($orderinfo[total], false)).'</amount>
							<currency>'.$settings[defaultrate].'</currency>
							<purchaseOrderNo>'.$oid.'</purchaseOrderNo>
							<CreditCardInfo>
								<cardNumber>'.tempdecryptit($orderinfo[cc_card_no]).'</cardNumber>
								<cvv>'.$orderinfo[cc_cvv2].'</cvv>
								<expiryDate>'.str_pad($orderinfo[cc_expir_month], 2, "0", STR_PAD_LEFT).'/'.substr($orderinfo[cc_expir_year],2,2).'</expiryDate>
							</CreditCardInfo>
						</Txn>
					</TxnList>
				</Payment>
			</SecurePayMessage>';
		
		$header_array = array(
			"POST / HTTP/1.0",
		    "Content-type: application/x-www-form-urlencoded",
		    "Content-length: " . strlen($data)
		);
		
		$header = "POST / HTTP/1.0\r\n".
			"Content-Type: application/x-www-form-urlencoded\r\n".
			"Content-Length: " . strlen($data) . "\r\n\r\n";
		
		$results = $cconnect->connect($data, $header, $header_array, (($this->class_vars[testmode]==true)?'https://www.securepay.com.au/test/payment':'https://www.securepay.com.au/xmlapi/payment'));
		$authr	 = $this->parse_return($results);
		
		//debug($authr);
		
		$auth["addon_message"] 	= $authr[responseText];
		$auth["addon_code"]		= $authr[responseCode];
		$auth["addon_oid"] 		= $authr[txnID];
		
		if ($authr["approved"] == "Yes") {
			$auth["approved"] = "Approved";
		} else {
			$auth["approved"] = "Error";
		}
		
		return $auth;
	}
	
	function parse_return ($in) {
		$attributes = array();
		$attributes = XMLParser($in);
		
		reset($attributes);
		while (list ($key, $val) = each ($attributes)) {
			$name = $val['tag']; $value = $val['value'];
			$out[$name] = $value;
		}
		
		return $out;
	}
	
	function install () {
		global $DB_site, $dbprefix;
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='securepay_xml', `internalname`='merchantid', `name`='Merchant ID', `options`='', `value`='', `help`='Your SecurePay merchant ID', `size`='20', `dorder`='1', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='securepay_xml', `internalname`='merchantpass', `name`='Merchant Password', `options`='', `value`='', `help`='Your SecurePay Password', `size`='20', `dorder`='2', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='securepay_xml', `internalname`='testmode', `name`='Test Mode', `options`='true::false->True::False', `value`='false', `help`='Test mode status. Set to false to go live.', `size`='0', `dorder`='3', `field_type`='dropdown'");
	}
	
	function uninstall () {
		global $DB_site, $dbprefix;
		$DB_site->query("DELETE FROM ".$dbprefix."modules_payment where `module`='securepay_xml'");
	}
}
?>
