<?PHP
/*
  include/payment/skipjack.php - 4/3/2009 - 8:32pm PST - 4.1.9
  
  SunShop Shopping Cart
  http://www.turnkeywebtools.com/sunshop/
  
  Copyright (c) 2001-2009 Turnkey Web Tools, Inc.
*/

$ADDON_NAME 	= "SkipJack";
$ADDON_VERSION 	= "2.1";
$ADDON_TYPE 	= "Processor";
$CLASS_NAME 	= "skipjack";

class skipjack {
	var $class_vars;
	
	function skipjack ($class_vars) {
		$this->class_vars = $class_vars;
	}
	
	function process () {
		global $cconnect, $settings, $sess;
		
		$userinfo	= $sess->gvar('userinfo');
		$orderinfo	= $sess->gvar('orderinfo');
		
		$oid = $sess->gvar('userid').date("mdyHis");
		
		$request = array(
			"sjname" 			=> $userinfo[bill_first_name]." ".$userinfo[bill_last_name],
			"Email" 			=> $userinfo[email],
			"Streetaddress" 	=> $userinfo[bill_address1],
			"Streetaddress2" 	=> $userinfo[bill_address2],
			"City" 				=> $userinfo[bill_city],
			"State" 			=> (($userinfo[bill_state]=='')?$userinfo[bill_other]:substr($userinfo[bill_state], 0, 2)),
			"Zipcode" 			=> $userinfo[bill_zip],
			"Country" 			=> $userinfo[bill_country],
			"Ordernumber" 		=> $oid,
			"Accountnumber" 	=> tempdecryptit($orderinfo[cc_card_no]),
			"cvv2" 				=> $orderinfo[cc_cvv2],
			"Month" 			=> $orderinfo[cc_expir_month],
			"Year" 				=> $orderinfo[cc_expir_year],
			"Serialnumber" 		=> $this->class_vars[sj_serialnumber],
			"Transactionamount" => number_format(p($orderinfo[total], false), 2, "", ""),
			"Orderstring" 		=> $oid."~".$settings[title]." Transaction~".p($orderinfo[total], false)."~1~N~||",
			"Shiptophone" 		=> $userinfo[phone]
		);
		
		if (count($request) > 0) {
			reset($request);
			while (list($name, $value) = each($request)) {
				$str .= "&".$name."=".$value;
			}
			$data = substr($str,1);
		}
		
		$header_array = array(
			"POST / HTTP/1.0",
		    "Content-type: application/x-www-form-urlencoded",
		    "Content-length: ".strlen($data)
		);
		
		$header = "POST / HTTP/1.0\r\n".
			"Content-Type: application/x-www-form-urlencoded\r\n".
			"Content-Length: " . strlen ($data) . "\r\n\r\n";
		
		$results = $cconnect->connect($data, $header, $header_array, $this->class_vars[url]);
		$auth	 = $this->parse_return($results);
		
		$result["addon_message"] 	= ($auth["szReturnCode"]==1)?$auth[szAuthorizationDeclinedMessage]:$auth["textReturnCode"];
		$result["addon_code"]		= $auth["szReturnCode"];
		$result["addon_oid"] 		= $oid;
		
		if ($auth["szIsApproved"] == 1) {
			$result["approved"] = "Approved";
		} else {
			$result["approved"] = "Error";
		}
		
		return $result;
	}
	
	function parse_return ($in) {
		$ReturnValues = array (
			"AUTHCODE",
			"szSerialNumber",
			"szTransactionAmount",
			"szAuthorizationResponseCode",
			"szReturnCode",
			"szIsApproved",
			"szAuthorizationDeclinedMessage",
			"szAVSResponseCode",
			"szAVSResponseMessage",
			"szOrderNumber",
			"szCVV2ResponseCode",
			"szCVV2ResponseMessage",
			"szTransactionFileName",
			"szCAVVResponseCode"
		);
		
		$szReturnCode = array(
			"1"=>"Status Complete (1)",
			"0"=>"Call Failed (0)",
			"-1"=>"Invalid length (-1)",
			"-35"=>"Invalid credit card number (-35)",
			"-37"=>"Failed communication (-37)",
			"-39"=>"Serial number is too short (-39)",
			"-51"=>"The zip code is invalid",
			"-52"=>"The shipto zip code is invalid",
			"-53"=>"Length of expiration date (-53)",
			"-54"=>"Length of account number date (-54)",
			"-55"=>"Length of street address (-55)",
			"-56"=>"Length of shipto street address (-56)",
			"-57"=>"Length of transaction amount (-57)",
			"-58"=>"Length of name (-58)",
			"-59"=>"Length of location (-59)",
			"-60"=>"Length of state (-60)",
			"-61"=>"Length of shipto state (-61)",
			"-62"=>"Length of order string (-62)",
			"-64"=>"Invalid phone number (-64)",
			"-65"=>"Empty name (-65)",
			"-66"=>"Empty email (-66)",
			"-67"=>"Empty street address (-66)",
			"-68"=>"Empty city (-68)",
			"-69"=>"Empty state (-69)",
			"-70"=>"Empty zip code (-70)",
			"-71"=>"Empty order number (-71)",
			"-72"=>"Empty account number (-72)",
			"-73"=>"Empty expiration month (-73)",
			"-74"=>"Empty expiration year (-74)",
			"-75"=>"Empty serial number (-75)",
			"-76"=>"Empty transaction amount (-76)",
			"-79"=>"Length of customer name (-79)",
			"-80"=>"Length of shipto customer name (-80)",
			"-81"=>"Length of customer location (-81)",
			"-82"=>"Length of customer state (-82)",
			"-83"=>"Length of shipto phone (-83)",
			"-84"=>"Pos Error duplicate ordernumber (-84)",
			"-91"=>"Pos Error CVV2 (-91)",
			"-92"=>"Pos Error Approval Code (-92)",
			"-93"=>"Pos Error Blind Credits Not Allowed (-93)",
			"-94"=>"Pos Error Blind Credits Failed (-94)",
			"-95"=>"Pos Error Voice Authorizations Not Allowed (-95)"
		);
		
		$szAVSResponseCode = array(
			"X" => "Exact match, 9 digit zip",
			"Y" => "Exact match, 5 digit zip",
			"A" => "Address match only",
			"W" => "9 digit match only",
			"Z" => "5 digit match only",
			"N" => "No address or zip match",
			"U" => "Address unavailable",
			"R" => "Issuer system unavailable",
			"E" => "Not a mail/phone order",
			"S" => "Service not supported"
		); 
		
		while (list($key,$code) = each($ReturnValues)) {
			$pos = strpos($in, $code);
			if ($pos) {
				$value = substr($in, $pos + strlen($code) + 1, strpos($in, "-->", $pos) - $pos - strlen($code) - 1);
				$response[$code] = $value;
			}
		}
		
		$response["textReturnCode"] = $szReturnCode[ $response["szReturnCode"] ];
		
		return $response;
	}
	
	function install () {
		global $DB_site, $dbprefix;
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='skipjack', `internalname`='sj_serialnumber', `name`='Serial Number', `options`='', `value`='', `help`='Your assigned SkipJack serial number.', `size`='0', `dorder`='1', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='skipjack', `internalname`='url', `name`='Transaction URL', `options`='', `value`='https://www.skipjackic.com/scripts/evolvcc.dll?Authorize', `help`='Transaction url. Leave to default if unless needed.', `size`='60', `dorder`='2', `field_type`='textbox'");
	}
	
	function uninstall () {
		global $DB_site, $dbprefix;
		$DB_site->query("DELETE FROM ".$dbprefix."modules_payment where `module`='skipjack'");
	}
}
?>
