<?PHP
/*
  include/payment/totaltrans.php - 4/3/2009 - 8:32pm PST - 4.1.9
  
  SunShop Shopping Cart
  http://www.turnkeywebtools.com/sunshop/
  
  Copyright (c) 2001-2009 Turnkey Web Tools, Inc.
*/

$ADDON_NAME 	= "TotalTrans";
$ADDON_VERSION 	= "2.1";
$ADDON_TYPE 	= "Processor";
$CLASS_NAME 	= "totaltrans";

class totaltrans {
	var $class_vars;
	
	function totaltrans ($class_vars) {
		$this->class_vars = $class_vars;
	}
	
	function process () {
		global $cconnect, $settings, $sess;
		
		$userinfo	= $sess->gvar('userinfo');
		$orderinfo	= $sess->gvar('orderinfo');
		
		$oid = $sess->gvar('userid')."-".date("mdyHis");
		
		/**** Login Information ****/
		$data   = "username=".$this->class_vars[ttUsername]."&";
		$data  .= "password=".$this->class_vars[ttPassword]."&";
		
		/**** Contact Information ****/
		$data .= "phone=".$userinfo[phone]."&";
		$data .= "address=".$userinfo[bill_address1]."&";
		$data .= "city=".$userinfo[bill_city]."&";
		$data .= "state=".(($userinfo[bill_state]=='')?$userinfo[bill_other]:substr($userinfo[bill_state], 0, 2))."&";
		$data .= "zip=".$userinfo[bill_zip]."&";
		$data .= "country=".$userinfo[bill_country]."&";
		$data .= "email=".$userinfo[email]."&";
		$data .= "ipaddress=".$_SERVER['REMOTE_ADDR']."&";
		
		/**** Credit Card Information ****/ 
		$data .= "cardholdername=".$orderinfo[cc_name_on_card]."&";
		$data .= "cardnumber=".tempdecryptit($orderinfo[cc_card_no])."&";
		$data .= "cvv=".$orderinfo[cc_cvv2]."&";
		$data .= "cardtype=".$orderinfo[card_type]."&";
		$data .= "expmonth=".$orderinfo[cc_expir_month]."&";
		$data .= "expyear=".$orderinfo[cc_expir_year]."&";
		
		/**** Transaction Information ****/ 
		$data .= "transtype=sale&";
		$data .= "format=csv&";
		$data .= ($this->class_vars[ttBankprocessor]!="")?"bankprocessor=".$this->class_vars[ttBankprocessor]."&":"";
		$data .= "reference=".$oid."&";
		$data .= "orderid=".$oid."&";
		$data .= "comment=".$settings[title]."%20Order%20Payment&";
		$data .= "amount=".p($orderinfo[total], false)."&";
		$data .= "currency=USD";
		
		$header_array = array(
			"POST / HTTP/1.0",
		    "Content-type: application/x-www-form-urlencoded",
		    "Content-length: ".strlen($data)
		);
		
		$header = "POST / HTTP/1.0\r\n".
			"Content-Type: application/x-www-form-urlencoded\r\n".
			"Content-Length: " . strlen ($data) . "\r\n\r\n";
		
		$results = $cconnect->connect($data, $header, $header_array, $this->class_vars[url]);
		$auth	 = $this->parse_return($results);
		
		$result["addon_message"] 	= $auth["response_reason_text"];
		$result["addon_code"]		= $auth["response_reason_code"];
		$result["addon_oid"] 		= $auth["trans_id"];
		
		if ($auth["response_code"] == "A") {
			$result["approved"] = "Approved";
		} else {
			$result["approved"] = "Error";
		}
		
		return $result;
	}
	
	function parse_return ($in) {
		$auth_array = explode(",", str_replace("\"", "", $in));
		$auth_results = array(
			"response_code" 		=> "$auth_array[0]",
			"response_reason_code"	=> "$auth_array[2]",
			"response_reason_text"	=> "$auth_array[3]",
			"trans_id"				=> "$auth_array[4]",
			"cvv_code"				=> "$auth_array[5]",
			"avs_code"				=> "$auth_array[6]",
			"pcr_code"				=> "$auth_array[7]"
		);
		return $auth_results;
	}
	
	function install () {
		global $DB_site, $dbprefix;
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='totaltrans', `internalname`='ttUsername', `name`='Merchant Username', `options`='', `value`='', `help`='Your assigned merchant username.', `size`='0', `dorder`='1', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='totaltrans', `internalname`='ttPassword', `name`='Merchant Password', `options`='', `value`='', `help`='Your assigned merchant password.', `size`='0', `dorder`='2', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='totaltrans', `internalname`='ttBankprocessor', `name`='Bank Processor', `options`='', `value`='', `help`='Leave blank unless you required.', `size`='0', `dorder`='3', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='totaltrans', `internalname`='url', `name`='Transaction URL', `options`='', `value`='https://secure.totaltrans.net/tt/transaction.php', `help`='Transaction url. Leave to default if unless needed.', `size`='60', `dorder`='4', `field_type`='textbox'");
	}
	
	function uninstall () {
		global $DB_site, $dbprefix;
		$DB_site->query("DELETE FROM ".$dbprefix."modules_payment where `module`='totaltrans'");
	}
}
?>
