<?PHP
/*
  include/plugins/google_checkout.php - 4/3/2009 - 8:32pm PST - 4.1.9
  
  SunShop Shopping Cart
  http://www.turnkeywebtools.com/sunshop/
  
  Copyright (c) 2001-2009 Turnkey Web Tools, Inc.
*/

$ADDON_NAME 	= "Google Checkout";
$ADDON_VERSION 	= "2.0";
$CLASS_NAME 	= "google_checkout";

class google_checkout {
	var $class_vars;
	var $ctype;
	var $cartinfo = array();
	
	function google_checkout ($class_vars) {
		$this->class_vars = $class_vars;
	}
	
	function pass_cart ($cartinfo) {
		for ($i=0; $i<count($cartinfo); $i++) {
			$temp = array(
				'name'			=> $cartinfo[$i][title],
				'description'	=> $cartinfo[$i][description],
				'quantity'		=> $cartinfo[$i][quantity],
				'price'			=> $cartinfo[$i][price],
				'tax_table'		=> '',
				'itemid'		=> $cartinfo[$i][items],
				'data'			=> $cartinfo[$i][data]
			);
			array_push($this->cartinfo, $temp);
		}
	}
	
	function render () {
		global $DB_site, $dbprefix, $settings, $abs_path, $lang, $sess, $cart;
		
		$userinfo	= $sess->gvar('userinfo');
		$orderinfo	= $sess->gvar('orderinfo');
		
		$this->pass_cart($cart->pass_cart());
		
		require_once($abs_path.'/include/plugins/google_checkout/googlecart.php');
		require_once($abs_path.'/include/plugins/google_checkout/googleitem.php');
		require_once($abs_path.'/include/plugins/google_checkout/googleshipping.php');
		require_once($abs_path.'/include/plugins/google_checkout/googletax.php');
		
		$gccart = new GoogleCart($this->class_vars[merchant_id], $this->class_vars[merchant_key], ($this->class_vars[sandbox]=='true')?"sandbox":"checkout", $settings[defaultrate]);
		$gccart->SetEditCartUrl($settings[shopurl]."index.php?l=cart_view");
		$gccart->SetContinueShoppingUrl($this->class_vars[continue_shopping]);
		$gccart->SetMerchantCalculations($settings[secureurl]."include/plugins/google_checkout/ss_responsehandler.php", "false", "true", "true");
		$gccart->SetMerchantPrivateData($cart->weight().'||'.$cart->subtotal(3));
		$gccart->SetRequestBuyerPhone('true');
                
		////////////////
		// Set Tax Rules
		////////////////
		
		$results = $DB_site->query("SELECT *, t.name as name FROM `".$dbprefix."taxes` t 
			LEFT JOIN `".$dbprefix."state_country` sc ON t.tvalue=sc.id WHERE
			t.`type`='".STATE."' OR t.`type`='".PROVINCE."'
		");
		while ($row = $DB_site->fetch_assoc($results)) {
			$tax_rule = new GoogleDefaultTaxRule($row[rate]/100, (($settings[taxtoshipping]==1)?'true':'false'));
			$tax_rule->SetStateAreas(ereg_replace("[^A-Za-z]", "", $row[abb]));
			$gccart->AddDefaultTaxRules($tax_rule);
		}
		
		$results = $DB_site->query("SELECT *, t.name as name FROM `".$dbprefix."taxes` t 
			LEFT JOIN `".$dbprefix."state_country` sc ON t.tvalue=sc.id WHERE
			t.`type`='".ZIPCODE."'
		");
		while ($row = $DB_site->fetch_assoc($results)) {
			$tax_rule = new GoogleDefaultTaxRule($row[rate]/100, (($settings[taxtoshipping]==1)?'true':'false'));
			$tax_rule->SetZipPatterns($row[name]);
			$gccart->AddDefaultTaxRules($tax_rule);
		}
		
		$results = $DB_site->query("SELECT *, t.name as name FROM `".$dbprefix."taxes` t 
			LEFT JOIN `".$dbprefix."state_country` sc ON t.tvalue=sc.id WHERE
			t.`type`='".COUNTRY."'
		");
		while ($row = $DB_site->fetch_assoc($results)) {
			$tax_rule = new GoogleDefaultTaxRule($row[rate]/100, (($settings[taxtoshipping]==1)?'true':'false'));
			$tax_rule->AddPostalArea($row[abb]);
			$gccart->AddDefaultTaxRules($tax_rule);
		}
		
		// Add Non Taxable
		$tax_table = new GoogleAlternateTaxTable("nontaxable");
		$tax_rule = new GoogleAlternateTaxRule(0);
		$tax_rule->SetWorldArea(true);
		$tax_table->AddAlternateTaxRules($tax_rule);
		$gccart->AddAlternateTaxTables($tax_table);
		
		////////////////
		// Set Item Data
		////////////////
		
		//function google_format($in) {
		//	$out = preg_replace("/[^a-zA-Z0-9 .-\/\[\]\"'()\$#@!*^%+=~`]/", "", $in);
		//	return $out;
		//}
		
		function google_format($in) {
			$replace = array('&#8482;', '&#174;', '&#169;', '&copy;', '&reg;', '&#0169;', '&#0174;', '&#0153;', '', '', '');
			$with = array('', '', '', '', '', '', '', '', '', '', '');
			return str_replace($replace, $with, $in);
		}
		
		
		$charge_shipping = 0;
		foreach ($this->cartinfo as $v) {
			$info = get('products', $v['itemid']);
			$item = new GoogleItem(xf(google_format(html_entity_decode($info['title']))), xf(google_format(html_entity_decode($v['description']))), $v['quantity'], $v['price'], $v['itemid'], $settings[weight_units], $info[weight]);
			$item->SetMerchantItemId($v['itemid']);
			$item->SetMerchantPrivateItemData(base64_encode($v['data']));
			if ($info[charge_tax] != 'y') $item->SetTaxTableSelector("nontaxable");
			if ($info[charge_shipping] != 'n') $charge_shipping = 1;
			$gccart->AddItem($item);
		}
        
		/////////////////////
		// Set Shipping Rules
		/////////////////////
		
		if ($charge_shipping == 0) {
			$ship = new GoogleMerchantCalculatedShipping("Standard Shipping", 0.00);
			$gccart->AddShipping($ship);
		} else {
			switch ($settings[shipmethod]) {
				case 'realtime':
					$ship_from = new GoogleShipFrom('Store_origin', $settings[city], $settings[country], $settings[zip], substr($settings[state], 0, 2));
					$GSPackage = new GoogleShippingPackage($ship_from, $settings[avg_width], $settings[avg_length], $settings[avg_height], $settings[dimension_units]);
					$ship = new GoogleCarrierCalculatedShipping('Carrier_shipping');
					$ship->addShippingPackage($GSPackage);
					
					// Fedex Pricing
					$map = array (
						'GROUNDHOMEDELIVERY' 	=> array('name' => 'Home Delivery', 'default' => 9.99),
						'FEDEXGROUND' 			=> array('name' => 'Ground', 'default' => 10.99),
						'FEDEXEXPRESSSAVER' 	=> array('name' => 'Express Saver', 'default' => 15.99),
						'FEDEX2DAY' 			=> array('name' => '2Day', 'default' => 16.99),
						'STANDARDOVERNIGHT' 	=> array('name' => 'Standard Overnight', 'default' => 27.99),
						'PRIORITYOVERNIGHT' 	=> array('name' => 'Priority Overnight', 'default' => 32.99),
						'FIRSTOVERNIGHT' 		=> array('name' => 'First Overnight', 'default' => 50.99)
					);
					$fedex = module_vars('fedex', 'shipping');
					$methods = explode('::', $fedex[accepted]);
					foreach ($methods as $v) {
						if (is_array($map[$v])) {
							$CCSoption = new GoogleCarrierCalculatedShippingOption($map[$v]['default'], "FedEx", $map[$v][name], p($settings[handling], false));
							$ship->addCarrierCalculatedShippingOptions($CCSoption);
						}
					}
					
					// UPS Pricing
					$map = array (
						'03' 	=> array('name' => 'Ground', 'default' => 9.99),
						'12' 	=> array('name' => '3 Day Select', 'default' => 12.99),
						'02' 	=> array('name' => '2nd Day Air', 'default' => 18.99),
						'59' 	=> array('name' => '2nd Day Air AM', 'default' => 20.99),
						'13' 	=> array('name' => 'Next Day Air Saver', 'default' => 24.99),
						'01'	=> array('name' => 'Next Day Air', 'default' => 27.99),
						'14'	=> array('name' => 'Next Day Air Early AM', 'default' => 57.99),
					);
					$ups = module_vars('ups', 'shipping');
					$methods = explode('::', $ups[accepted]);
					foreach ($methods as $v) {
						if (is_array($map[$v])) {
							$CCSoption = new GoogleCarrierCalculatedShippingOption($map[$v]['default'], "UPS", $map[$v][name], p($settings[handling], false));
							$ship->addCarrierCalculatedShippingOptions($CCSoption);
						}
					}
					
					// USPS Pricing
					$map = array (
						'Media Mail' 	=> array('name' => 'Media Mail', 'default' => 9.99),
						'Parcel Post' 	=> array('name' => 'Parcel Post', 'default' => 15.99),
						'Priority Mail'	=> array('name' => 'Priority Mail', 'default' => 18.99),
						'Express Mail'	=> array('name' => 'Express Mail', 'default' => 20.99),
					);
					$usps = module_vars('usps', 'shipping');
					$methods = explode('::', $usps[accepted]);
					foreach ($methods as $v) {
						if (is_array($map[$v])) {
							$CCSoption = new GoogleCarrierCalculatedShippingOption($map[$v]['default'], "USPS", $map[$v][name], p($settings[handling], false));
							$ship->addCarrierCalculatedShippingOptions($CCSoption);
						}
					}
					$gccart->AddShipping($ship);
					break;
				
				case 'shiptable':
					$ship = new GoogleMerchantCalculatedShipping("Standard Shipping", 15.00);
					$gccart->AddShipping($ship);
					if (p($settings[expedited]) != p(0)) {
						$ship = new GoogleMerchantCalculatedShipping("Expedited Shipping", p(15.00+$settings[expedited], false));
						$gccart->AddShipping($ship);
					}
					break;
				
				default:
					$shipping = get_shipping();
					$ship = new GoogleMerchantCalculatedShipping("Standard Shipping", $shipping[rates]);
					$gccart->AddShipping($ship);
					if (p($settings[expedited]) != p(0)) {
						$ship = new GoogleMerchantCalculatedShipping("Expedited Shipping", p($shipping[rates]+$settings[expedited], false));
						$gccart->AddShipping($ship);
					}	
					break;
			}
		}
		return template('plugin_google_checkout.html', array('out' => array('button_output' => $gccart->CheckoutButtonCode($this->class_vars[size], true, 'en_US', true, $this->class_vars[bg])), 'lang' => $lang['plugin']));
	}
	
	function require_files () {
		global $abs_path, $class_vars, $request, $settings;
		$class_vars = module_vars('google_checkout', 'plugins');
		require_once($abs_path.'/include/plugins/google_checkout/googlerequest.php');
		$request = new GoogleRequest($class_vars[merchant_id], $class_vars[merchant_key], ($class_vars[sandbox])?"sandbox":"checkout", $settings[defaultrate]);
	}
	
	function send_merchant_order ($order) {
		global $class_vars, $request;
		$this->require_files();
		return $this->parse_return($request->SendMerchantOrderNumber($order[pm_orderid], $order[id]));
	}
	
	function send_buyer_message ($order) {
		global  $DB_site, $dbprefix, $class_vars, $request;
		$this->require_files();
		$note = $DB_site->query_first("SELECT * FROM `".$dbprefix."orders_notes` WHERE `orderid`='".$_GET[id]."' AND `type`='A' AND `private`='0'ORDER BY `id` DESC");
		return $this->parse_return($request->SendBuyerMessage($order[pm_orderid], xf($note[note])));
	}
	
	function charge_order ($order) {
		global $class_vars, $request;
		$this->require_files();
		return $this->parse_return($request->SendChargeOrder($order[pm_orderid], $order[total]));
	}
	
	function refund_order ($order) {
		global $class_vars, $request, $sess;
		$this->require_files();
		return $this->parse_return($request->SendRefundOrder($order[pm_orderid], $order[total], 'Request from '.$sess->gvar('adminid').' through SunShop.'));
	}
	
	function cancel_order ($order) {
		global $class_vars, $request, $sess;
		$this->require_files();
		return $this->parse_return($request->SendCancelOrder($order[pm_orderid], 'Request from '.$sess->gvar('adminid').' through SunShop.', ''));
	}
	
	function process_order ($order) {
		global $class_vars, $request;
		$this->require_files();
		return $this->parse_return($request->SendProcessOrder($order[pm_orderid]));
	}
	
	function deliver_order ($order) {
		global $class_vars, $request;
		$this->require_files();
		if ($order[carrier] == "") return "Please set the shipping information on the 'Status Info' tab first.";
		return $this->parse_return($request->SendDeliverOrder($order[pm_orderid], $order[carrier], $order[number], 'true'));
	}
	
	function send_tracking ($order) {
		global $class_vars, $request;
		$this->require_files();
		if ($order[carrier] == "") return "Please set the shipping information on the 'Status Info' tab first.";
		return $this->parse_return($request->SendTrackingData($order[pm_orderid], $order[carrier], $order[number]));
	}
	
	function archive_order ($order) {
		global $class_vars, $request;
		$this->require_files();
		return $this->parse_return($request->SendArchiveOrder($order[pm_orderid]));
	}
	
	function unarchive_order ($order) {
		global $class_vars, $request;
		$this->require_files();
		return $this->parse_return($request->SendUnarchiveOrder($order[pm_orderid]));
	}
	
	function load_actions () {
		$map_actions = array (
			'Google Checkout: Send Shopping Cart Order Number' => 'send_merchant_order',
			'Google Checkout: Update Status to \'Processing Order\'' => 'process_order',
			'Google Checkout: Send Latest Order Note' => 'send_buyer_message',
			'Google Checkout: Charge Order' => 'charge_order',
			'Google Checkout: Ship Order & Update Tracking Info' => 'send_tracking',
			//'Google Checkout: Ship Order & Update Tracking Info' => 'deliver_order',
			'Google Checkout: Archive Order' => 'archive_order',
			'Google Checkout: Un-Archive Order' => 'unarchive_order',
			'Google Checkout: Refund Order' => 'refund_order',
			'Google Checkout: Cancel Order' => 'cancel_order'
		);
		return $map_actions;
	}
	
	function parse_return ($in) {
		global $request;
		$replace = array('&lt;', '&gt;', '&quot;');
		$replace_with = array('<', '>', '"');
		for($i=1; $i<count($in); $i++) $data .= str_replace($replace, $replace_with, $in[$i]);
		
		$out = parse_xml($data);
		$attributes = array();
		$attributes = XMLParser($data);
		
		reset($attributes);
		while (list ($key, $val) = each ($attributes)) {
			$name = $val['tag']; $value = $val['value'];
			$out[$name] = $value;
		}
		
		if (trim($out['error-message'])!="") $mess = trim($out['error-message']);
		else $mess = "Request received successfully.";
		return "Google Checkout: ".$mess;
	}

	function install () {
		global $DB_site, $dbprefix, $settings;
		$DB_site->query("INSERT INTO ".$dbprefix."modules_plugins set `module`='google_checkout', `internalname`='enabled', `name`='Enabled', `moptions`='', `options`='0::1->Off::On', `value`='1', `help`='', `size`='0', `dorder`='1', `field_type`='dropdown'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_plugins set `module`='google_checkout', `internalname`='merchant_id', `name`='Merchant ID', `options`='', `value`='', `help`='Your merchant ID.', `size`='30', `dorder`='2', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_plugins set `module`='google_checkout', `internalname`='merchant_key', `name`='Merchant Key', `options`='', `value`='', `help`='Your merchant key.', `size`='30', `dorder`='3', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_plugins set `module`='google_checkout', `internalname`='continue_shopping', `name`='Continue Shopping URL', `options`='', `value`='".$settings[shopurl]."', `help`='URL to take google checkout customers if they wish to continue shopping.', `size`='60', `dorder`='4', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_plugins set `module`='google_checkout', `internalname`='bg', `name`='Image Style', `moptions`='', `options`='trans::white->Transparent Background::White Background', `value`='trans', `help`='Image background type that will be used todisplay your image.', `size`='0', `dorder`='5', `field_type`='dropdown'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_plugins set `module`='google_checkout', `internalname`='size', `name`='Image Size', `moptions`='', `options`='small::medium::large->Small::Medium::Large', `value`='small', `help`='Image size that will be used to display your image.', `size`='0', `dorder`='6', `field_type`='dropdown'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_plugins set `module`='google_checkout', `internalname`='auto', `name`='Auto Charge', `moptions`='', `options`='0::1->Off::On', `value`='1', `help`='Automatically charge new orders when they are received?', `size`='0', `dorder`='7', `field_type`='dropdown'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_plugins set `module`='google_checkout', `internalname`='sandbox', `name`='Sandbox Mode', `options`='true::false->Yes::No', `value`='false', `help`='Set to this value for testing mode. Set to \"No\" for LIVE.', `size`='0', `dorder`='8', `field_type`='dropdown'");
	}
	
	function uninstall () {
		global $DB_site, $dbprefix;
		$DB_site->query("DELETE FROM ".$dbprefix."modules_plugins where `module`='google_checkout'");
	}
}
?>