<?PHP
/*
  include/plugins/plugin_shipping_estimator.php - 4/3/2009 - 8:32pm PST - 4.1.9
  
  SunShop Shopping Cart
  http://www.turnkeywebtools.com/sunshop/
  
  Copyright (c) 2001-2009 Turnkey Web Tools, Inc.
*/

$ADDON_NAME 	= "Shipping Estimator (Realtime Shipping)";
$ADDON_VERSION 	= "1.1";
$CLASS_NAME 	= "shipping_estimator";

class shipping_estimator {
	var $output;
	
	function shipping_estimator () {
		return;
	}
	
	function render () {
		global $DB_site, $dbprefix, $settings, $lang, $userinfo, $sess, $lang;
		if ($settings[shipmethod] == 'realtime') {
			if ($_GET[zip_code] != "" && $_GET[zip_code] != "Postal Code") {
				$hide[] = 'Zip Box';
				$info = $this->zip_lookup($_GET[zip_code]);
				
				if ($info[city] != "") {
					$userinfo[ship_city]    = $info[city];
					$userinfo[ship_state]   = $info[state];
					$userinfo[ship_country] = $info[country];
					$userinfo[ship_zip]     = $_GET[zip_code];
					
					$sess->svar('userinfo', $userinfo);
					$shipping = get_shipping();
					$sess->dvar('userinfo');
					
					$estimate[results] = '<select>'.$shipping[values].'</select>';
				} else {
					$hide = array('Results');
					$estimate[results] = $lang['plugin']['invalid'];
				}
			} else {
				$hide[] = 'Results';
			}
			$template = template('plugin_shipping_estimator.html', array('estimate' => $estimate, 'lang' => $lang['plugin'], 'hide' => $hide));
		}
		
		return $template;
	}
	
	function connect ($zipcode, $country='') {
		global $abs_path, $settings;
		include_once $abs_path.'/include/classes/class.connect.php';
		$connect = new curl_connect();
		$results = $connect->connect("postalcode=".$zipcode."&maxRows=1&country=".$country, $header, array(), 'http://ws.geonames.org/postalCodeSearch');
		return parse_xml($results);
	}
	
	function zip_lookup ($zipcode) {
		global $abs_path, $settings;
		
		// Canada Default?
		if ($settings[country] == "CA") $zipcode = substr($zipcode, 0, 3);
		
		// Try Default Country First
		$parsed = $this->connect($zipcode, $settings[country]);
		
		// Fallback To All Countries
		if ($parsed[geonames][totalResultsCount] == 0) {
			$parsed = $this->connect($zipcode);
		}
		
		// Blame Canada!
		if ($parsed[geonames][totalResultsCount] == 0) {
			$zipcode = substr($zipcode, 0, 3);
			$parsed = $this->connect($zipcode, 'CA');
		}
		
		return array('city' => $parsed[geonames][code][name], 'state' => $parsed[geonames][code][adminCode1], 'country' => $parsed[geonames][code][countryCode]);
	}
	
	function install () {
		global $DB_site, $dbprefix;
		$DB_site->query("INSERT INTO ".$dbprefix."modules_plugins set `module`='shipping_estimator', `internalname`='enabled', `name`='Enabled', `moptions`='', `options`='0::1->Off::On', `value`='1', `help`='', `size`='0', `dorder`='1', `field_type`='dropdown'");
	}
	
	function uninstall () {
		global $DB_site, $dbprefix;
		$DB_site->query("DELETE FROM ".$dbprefix."modules_plugins where `module`='shipping_estimator'");
	}
}
?>