<?PHP
/*
  include/shipping/aus_post.php - 4/3/2009 - 8:32pm PST - 4.1.9
  
  SunShop Shopping Cart
  http://www.turnkeywebtools.com/sunshop/
  
  Copyright (c) 2001-2009 Turnkey Web Tools, Inc.
*/
  
$ADDON_NAME 	= "AUS";
$ADDON_FULLNAME	= "Australia Post";
$ADDON_VERSION 	= "2.1";
$ADDON_TYPE 	= "Shipping";
$CLASS_NAME 	= "aus_integration";

class aus_integration {
	var $class_vars;
	var $data;
	var $package_id = 0;
	
	var $shipv = array(
		"STANDARD",
		"EXPRESS",
		"AIR",
		"ECONOMY",
		"SEA"
	);
	
	var $shipn = array(
		"Domestic Parcel Post",
		"Domestic Express Parcel Post",
		"International Air Parcel Post",
		"International Economy Parcel Post",
		"International Sea Parcel Post"
	);
	
	function aus_integration ($class_vars) {
		$this->class_vars = $class_vars;
	}
	
	function start () {
		$this->data = "Service_Type=<!--//SHIP_CODE//-->&Quantity=1&";
	}
	
	function setaddress ($from_city, $from_state, $from_zip, $from_country, $to_city, $to_state, $to_zip, $to_country) {
		$this->data .= "Pickup_Postcode=".$from_zip."&";
		$this->data .= "Destination_Postcode=".$to_zip."&";
		$this->data .= "Country=".$to_country."&";
    }
	
	function add_package($weight, $length="", $width="", $height="") {
		$this->data .= "Weight=".$weight."&";
		$this->data .= "Length=".$length."&";
		$this->data .= "Width=".$width."&";
		$this->data .= "Height=".$height;
	}
	
	function end_all () {
		$this->data .= "";
	}
	
	function process () {
		global $settings, $cconnect, $discounts, $coupon, $set_free;
		$return = array();
		$temp = explode("::", $this->class_vars[accepted]);
		for ($i=0; $i<count($temp); $i++) {
			$meth = $temp[$i];
			$methods[$meth] = 1;
		}
		
		$free = array();
		$temp = explode("::", $this->class_vars[free]);
		for ($i=0; $i<count($temp); $i++) {
			array_push($free, $temp[$i]);
		}
		
		for ($i=0; $i<count($this->shipv); $i++) {
			$temp = $this->shipv[$i];
			if ($methods[$temp] == 1) {
				$set_free = (($discounts[free_shipping]==1 || $coupon[free_shipping]==1) && in_array($temp, $free))?1:0;
				$data = str_replace("<!--//SHIP_CODE//-->", $temp, $this->data);
				
				$header_array = array (
					"POST / HTTP/1.0",
				    "Content-type: application/x-www-form-urlencoded",
				    "Content-length: ".strlen($data)
				);
				
				$header = "POST / HTTP/1.0\r\n".
					"Content-Type: application/x-www-form-urlencoded\r\n".
					"Content-Length: " . strlen ($data) . "\r\n\r\n";
				
				$results = $cconnect->connect($data, $header, $header_array, $this->class_vars[url]);
				$result	= $this->parse_return($results, $i);
				
				$return = array_merge($return, $result);
			}
			
		}
		
		return $return;
	}
	
	function parse_return ($in, $num) {
		global $set_free;
	    $attributes = explode("\n", $in);
		for ($i=0; $i<count($attributes); $i++) {
			$split = explode("=", $attributes[$i]);
			$key = trim($split[0]);
			$val = trim($split[1]);
			$rarray[$key] = $val;
		}
		
		$return[$num][status]		= ($rarray[err_msg]=="OK")?"Sucess":"Failure";
		$return[$num][statuscode]	= ($rarray[err_msg]=="OK")?1:0;
		$return[$num][error]		= $rarray[err_msg];
		$return[$num][errorcode]	= ($rarray[err_msg]=="OK")?0:1;
		$return[$num][rate]			= ($set_free==1)?0:$rarray[charge];
		$return[$num][method]		= $this->shipn[$num];
		
		return $return;
	}
	
	function install () {
		global $DB_site, $dbprefix;
		$DB_site->query("INSERT INTO ".$dbprefix."modules_shipping set `module`='aus_integration', `internalname`='enabled', `name`='Enabled', `moptions`='', `options`='0::1->Off::On', `value`='0', `help`='', `size`='0', `dorder`='1', `field_type`='dropdown'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_shipping set `module`='aus_integration', `internalname`='url', `name`='', `moptions`='', `options`='', `value`='http://drc.edeliver.com.au/ratecalc.asp', `help`='', `size`='40', `dorder`='', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_shipping set `module`='aus_integration', `internalname`='accepted', `name`='Shipping Methods', `moptions`='".implode("::", $this->shipv)."->".implode("::", $this->shipn)."', `options`='', `value`='STANDARD::EXPRESS', `help`='', `size`='0', `dorder`='2', `field_type`='dropdown'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_shipping set `module`='aus_integration', `internalname`='free', `name`='Shipping Methods', `moptions`='".implode("::", $this->shipv)."->".implode("::", $this->shipn)."', `options`='', `value`='STANDARD', `help`='Please select any methods you wish to offer free when free shipping is provided using discounts or coupons.', `size`='0', `dorder`='3', `field_type`='dropdown'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_shipping set `module`='aus_integration', `internalname`='multi_support', `name`='', `moptions`='', `options`='', `value`='0', `help`='', `size`='0', `dorder`='', `field_type`='textbox'");
	}
	
	function uninstall () {
		global $DB_site, $dbprefix;
		$DB_site->query("DELETE FROM ".$dbprefix."modules_shipping where `module`='aus_integration'");
	}
}
?>
