<?PHP
/*
  include/shipping/fedex_frieght.php - 4/3/2009 - 8:32pm PST - 4.1.9
  
  SunShop Shopping Cart
  http://www.turnkeywebtools.com/sunshop/
  
  Copyright (c) 2001-2009 Turnkey Web Tools, Inc.
*/
  
$ADDON_NAME 	= "FedEx Freight";
$ADDON_FULLNAME	= "FedEx Freight";
$ADDON_VERSION 	= "2.1";
$ADDON_TYPE 	= "Shipping";
$CLASS_NAME 	= "fedex_freight";

class fedex_freight {
	var $class_vars;
	var $data;
	var $ship_date;
	var $package_num = 0;
	
	function fedex_freight ($class_vars) {
		$this->class_vars = $class_vars;
	}
	
	function start () {
		$this->data .= "as_shipterms=prepaid&";
		$this->data .= "as_iamthe=shipper&";
		$this->data .= "as_acctnbr=".$this->class_vars[acc_num]."&";
		$this->data .= "as_residentialpickup=".$this->class_vars[resp]."&";
		$this->data .= "as_residentialdelivery=".$this->class_vars[resd]."&";
		$this->data .= "as_freezable=".$this->class_vars[freeze]."&";
		$this->data .= "as_callbefore=".$this->class_vars[call]."&";
		$this->data .= "as_liftgate=".$this->class_vars[gate]."&";
	}
	
	function setaddress ($from_city, $from_state, $from_zip, $from_country, $to_city, $to_state, $to_zip, $to_country) {
		$this->data .= "as_shzip=".$from_zip."&";
		$this->data .= "as_shcntry=".$from_country."&";
		$this->data .= "as_cnzip=".$to_zip."&";
		$this->data .= "as_cncntry=".$to_country."&";
    }
	
	function add_package($weight, $length="", $width="", $height="") {
		$this->package_num++;
		$this->data .= "as_class".$this->package_num."=".$this->class_vars[code]."&";
		$this->data .= "as_weight".$this->package_num."=".$weight."&";
	}
	
	function end_all () {
	}
	
	function process () {
		global $settings, $cconnect;
		$header_array = array(
			"POST / HTTP/1.0",
			"Content-type: application/x-www-form-urlencoded",
			"Content-length: ".strlen($this->data)
		);
				
		$header = "POST / HTTP/1.0\r\n".
			"Content-Type: application/x-www-form-urlencoded\r\n".
			"Content-Length: " . strlen ($this->data) . "\r\n\r\n";
				
		$results = $cconnect->connect($this->data, $header, $header_array, $this->class_vars[url]);
		$result	= $this->parse_return($results);
		
		if ($result[RatingError] != "") {
			$return[0][status]		= "Failed";
			$return[0][statuscode]	= 0;
			$return[0][error]		= $result[RatingError];
			$return[0][errorcode]	= 0;
			$return[0][rate]		= 0;
			$return[0][method]		= 0;
		} else {
			$return[0][status]		= "OK";
			$return[0][statuscode]	= 1;
			$return[0][error]		= 0;
			$return[0][errorcode]	= "";
			$return[0][rate]		= str_replace("\$", "", $result[RatingResults][NetFreightCharges]);
			$return[0][method]		= "FedexFreight";
			$num++;
		}
		
		return $return;
	}
	
	
	function parse_return ($in) {
		$rarray = parse_xml($in, array('LineItemDetail'), array('/LineItemDetail id="([0-9]*)"/'), array('LineItemDetail'));
		return $rarray;
	}
	
	function install () {
		global $DB_site, $dbprefix;
		$DB_site->query("INSERT INTO ".$dbprefix."modules_shipping set `module`='fedex_freight', `internalname`='enabled', `name`='Enabled', `moptions`='', `options`='0::1->Off::On', `value`='0', `help`='', `size`='0', `dorder`='1', `field_type`='dropdown'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_shipping set `module`='fedex_freight', `internalname`='url', `name`='', `moptions`='', `options`='', `value`='http://www.fedexfreight.fedex.com/XMLRating.jsp', `help`='', `size`='40', `dorder`='', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_shipping set `module`='fedex_freight', `internalname`='acc_num', `name`='Account Number', `moptions`='', `options`='', `value`='', `help`='', `size`='0', `dorder`='2', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_shipping set `module`='fedex_freight', `internalname`='code', `name`='Freight Class', `moptions`='', `options`='050::055::060::070::077::085::092::100:110::125::150::175::200:250::300->050::055::060::070::077::085::092::100:110::125::150::175::200:250::300', `value`='050', `help`='Will this item be picked up from a residential location?', `size`='0', `dorder`='3', `field_type`='dropdown'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_shipping set `module`='fedex_freight', `internalname`='resp', `name`='Residential Pickup', `moptions`='', `options`='N::Y->No::Yes', `value`='N', `help`='Will this item be picked up from a residential location?', `size`='0', `dorder`='4', `field_type`='dropdown'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_shipping set `module`='fedex_freight', `internalname`='resd', `name`='Residential Drop Off', `moptions`='', `options`='N::Y->No::Yes', `value`='N', `help`='Will this item be dropped off at a residential location?', `size`='0', `dorder`='5', `field_type`='dropdown'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_shipping set `module`='fedex_freight', `internalname`='freeze', `name`='Freezable', `moptions`='', `options`='N::Y->No::Yes', `value`='N', `help`='Freezable protection required?', `size`='0', `dorder`='6', `field_type`='dropdown'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_shipping set `module`='fedex_freight', `internalname`='gate', `name`='Lift Gate', `moptions`='', `options`='N::Y->No::Yes', `value`='N', `help`='List gate required?', `size`='0', `dorder`='7', `field_type`='dropdown'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_shipping set `module`='fedex_freight', `internalname`='multi_support', `name`='', `moptions`='', `options`='', `value`='0', `help`='', `size`='0', `dorder`='', `field_type`='textbox'");
	}
	
	function uninstall () {
		global $DB_site, $dbprefix;
		$DB_site->query("DELETE FROM ".$dbprefix."modules_shipping where `module`='fedex_freight'");
	}
}
?>
