<?PHP
/*
  include/shipping/intershipper.php - 4/3/2009 - 8:32pm PST - 4.1.9
  
  SunShop Shopping Cart
  http://www.turnkeywebtools.com/sunshop/
  
  Copyright (c) 2001-2009 Turnkey Web Tools, Inc.
*/
  
$ADDON_NAME 	= "INT";
$ADDON_FULLNAME	= "Intershipper v2.10";
$ADDON_VERSION 	= "2.2";
$ADDON_TYPE 	= "Shipping";
$CLASS_NAME 	= "int_integration";

class int_integration {
	var $class_vars;
	var $data;
	var $ship_date;
	var $package_id = 0;
	
	var $shipv = array("DHL", "FDX", "UPS", "USP", "ARB");
	var $shipn = array("DHL World Wide Express", "Federal Express", "United Parcel Service", "U.S. Postal Service", "AirBorne");
	
	var $packv = array("BOX", "ENV", "LTR", "MEM", "TUB");
	var $packn = array("Box", "Envelope", "Letter", "Media Mail", "Tube");
	
	var $classesv = array("1DY", "2DY", "3DY", "GND");
	var $classesn = array("1 Day", "2 Day", "3 Day", "Ground");
	
	function int_integration ($class_vars) {
		$this->class_vars = $class_vars;
	}
	
	function start () {
		$this->data  = 'Version=2.0.0.0&';
		$this->data .= 'ShipmentID='.$none.'&';
		$this->data .= 'Username='.$this->class_vars[acc_id].'&';
		$this->data .= 'Password='.$this->class_vars[acc_pass].'&';
		
		$acc_arr = explode("::", $this->class_vars[accepted]); $acc_num = count($acc_arr);
		$this->data .= 'TotalCarriers='.$acc_num.'&';
		for ($i=1; $i<=$acc_num; $i++) {
			$acct = "account_".$acc_arr[($i-1)];
			$this->data .= 'CarrierCode'.$i.'='.$acc_arr[($i-1)].'&';
			$this->data .= 'CarrierAccount'.$i.'='.$this->class_vars[$acct].'&';
			$this->data .= 'CarrierInvoiced'.$i.'=0&';
		}
		
		$class_arr = explode("::", $this->class_vars[classes]); $class_num = count($class_arr);
		$this->data .= 'TotalClasses='.$class_num.'&';
		for ($i=1; $i<=$class_num; $i++) {
			$this->data .= 'ClassCode'.$i.'='.$class_arr[($i-1)].'&';
		}
		
		$this->data .= 'DeliveryType='.$this->class_vars[del_type].'&';
		$this->data .= 'ShipMethod='.$this->class_vars[ship_meth].'&';
	}
	
	function setaddress ($from_city, $from_state, $from_zip, $from_country, $to_city, $to_state, $to_zip, $to_country) {
		$this->data .= 'OriginationCity='.urlencode($from_city).'&';
		$this->data .= 'OriginationState='.$from_state.'&';
		$this->data .= 'OriginationPostal='.$from_zip.'&';
		$this->data .= 'OriginationCountry='.$from_country.'&';
		$this->data .= 'DestinationCity='.urlencode($to_city).'&';
		$this->data .= 'DestinationState='.$to_state.'&';
		$this->data .= 'DestinationPostal='.$to_zip.'&';
		$this->data .= 'DestinationCountry='.$to_country.'&';
    }
	
	function add_package($weight, $length="", $width="", $height="") {
		global $settings;
		$this->package_id++;
		$this->data .= 'BoxID'.$this->package_id.'=BoxNum'.$this->package_id.'&';
		$this->data .= 'Weight'.$this->package_id.'='.$weight.'&';
		$this->data .= 'WeightUnit'.$this->package_id.'='.$settings[weight_units].'&';
		$this->data .= 'Length'.$this->package_id.'='.$length.'&';
		$this->data .= 'Width'.$this->package_id.'='.$width.'&';
		$this->data .= 'Height'.$this->package_id.'='.$height.'&';
		$this->data .= 'DimensionalUnit'.$this->package_id.'='.$settings[dimension_units].'&';
		$this->data .= 'Packaging'.$this->package_id.'='.$this->class_vars[box_type].'&';
		$this->data .= 'Contents'.$this->package_id.'=OTR&';
		$this->data .= 'Cod'.$this->package_id.'=0&';
		$this->data .= 'Insurance'.$this->package_id.'=0&';
	}
	
	function end_all () {
		global $settings;
		$this->data .= 'Currency='.$settings[defaultrate].'&';
		$this->data .= 'TotalPackages='.$this->package_id;
	}
	
	function process () {
		global $settings, $cconnect;
		$results = $cconnect->connect($this->data, $header, array(), $this->class_vars[url]);
		$result	= $this->parse_return($results);
		
		if ($result[shipment][error] != "") {
			$return[0][status]	= "Failed";
			$return[0][statuscode]	= 0;
			$return[0][error]	= $result[shipment][error];
			$return[0][errorcode]	= 1;
			$return[0][rate]	= 0;
			$return[0][method]	= 0;
		} else {
			while (list ($key, $val) = @each ($result[shipment][package])) {
				while (list ($key2, $val2) = @each ($result[shipment][package][$key][quote])) {
					$carrier_suff	= $result[shipment][package][$key][quote][$key2][carrier][code];
					$carrier_name	= $result[shipment][package][$key][quote][$key2][carrier][name];
					$method_suff	= $result[shipment][package][$key][quote][$key2][service][code];
					$method_name	= $result[shipment][package][$key][quote][$key2][service][name];
					$ship_amount	= $result[shipment][package][$key][quote][$key2][rate][amount];
					
					$parse_array[$carrier_suff][$method_suff][amount] += $ship_amount;
					$parse_array[$carrier_suff][$method_suff][name] = $carrier_name;
					$parse_array[$carrier_suff][$method_suff][method] = $method_name;
					$parse_array[$carrier_suff][$method_suff][hitnum] += 1;
				}
				$total++;
			}
			
			$num = 0;
			while (list ($key, $val) = @each ($parse_array)) {
				while (list ($key2, $val2) = @each ($parse_array[$key])) {
					if ($parse_array[$key][$key2][hitnum] == $total) {
						$amount = $parse_array[$key][$key2][amount];
						$change = substr($amount, -2);
						$dollar = substr($amount, 0, -2);
						$return[$num][status]		= "Successful";
						$return[$num][statuscode]	= 1;
						$return[$num][error]		= "";
						$return[$num][errorcode]	= 0;
						$return[$num][rate]		= $dollar.".".$change;
						$return[$num][method]		= $parse_array[$key][$key2][method];
					}
					$num++;
				}
				
			}
			
		}
		
		return $return;
	}
	
	function parse_return ($in) {
		$in = str_replace("<?xml version=\"1.0\" ?>", "", $in);
		$in = str_replace("<?xml version=\"1.0\"?>", "", $in);
		$in = preg_replace("/quote id=\"([0-9]*)\"/", "quote", $in);
		$in = preg_replace("/package id=\"([0-9]*)\"/", "package", $in);
		$in = preg_replace("/ unit=\"([^\"]*)\"/", "", $in);
		$rarray = parse_xml($in, array('package', 'quote'));
		return $rarray;
	}
	
	function install () {
		global $DB_site, $dbprefix;
		$DB_site->query("INSERT INTO ".$dbprefix."modules_shipping set `module`='int_integration', `internalname`='enabled', `name`='Enabled', `moptions`='', `options`='0::1->Off::On', `value`='0', `help`='', `size`='0', `dorder`='1', `field_type`='dropdown'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_shipping set `module`='int_integration', `internalname`='url', `name`='', `moptions`='', `options`='', `value`='https://www.intershipper.com/Interface/Intershipper/XML/v2.0/HTTP.jsp', `help`='', `size`='40', `dorder`='', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_shipping set `module`='int_integration', `internalname`='acc_id', `name`='Account ID', `moptions`='', `options`='', `value`='', `help`='', `size`='20', `dorder`='2', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_shipping set `module`='int_integration', `internalname`='acc_pass', `name`='Account Password', `moptions`='', `options`='', `value`='', `help`='', `size`='20', `dorder`='3', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_shipping set `module`='int_integration', `internalname`='accepted', `name`='Supported Carriers', `moptions`='".implode("::", $this->shipv)."->".implode("::", $this->shipn)."', `options`='', `value`='FDX::UPS:USP', `help`='', `size`='0', `dorder`='5', `field_type`='dropdown'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_shipping set `module`='int_integration', `internalname`='classes', `name`='Supported Methods', `moptions`='".implode("::", $this->classesv)."->".implode("::", $this->classesn)."', `options`='', `value`='1DY::2DY::3DY::GND', `help`='', `size`='0', `dorder`='6', `field_type`='dropdown'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_shipping set `module`='int_integration', `internalname`='box_type', `name`='Typical Package Type', `moptions`='', `options`='".implode("::", $this->packv)."->".implode("::", $this->packn)."', `value`='BOX', `help`='', `size`='0', `dorder`='8', `field_type`='dropdown'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_shipping set `module`='int_integration', `internalname`='del_type', `name`='Customer Classification', `moptions`='', `options`='RES::COM->Residential::Commercial', `value`='RES', `help`='', `size`='0', `dorder`='9', `field_type`='dropdown'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_shipping set `module`='int_integration', `internalname`='ship_meth', `name`='Shipping Method', `moptions`='', `options`='DRP::PCK::SCD->Drop Off At Carrier::Schedule A Pickup::Regularly Scheduled Pickup', `value`='DRP', `help`='', `size`='0', `dorder`='10', `field_type`='dropdown'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_shipping set `module`='int_integration', `internalname`='multi_support', `name`='', `moptions`='', `options`='', `value`='0', `help`='', `size`='0', `dorder`='', `field_type`='textbox'");
	}
	
	function uninstall () {
		global $DB_site, $dbprefix;
		$DB_site->query("DELETE FROM ".$dbprefix."modules_shipping where `module`='int_integration'");
	}
}
?>
