<?PHP
/*
  include/shipping/ups.php - 4/3/2009 - 8:32pm PST - 4.1.9
  
  SunShop Shopping Cart
  http://www.turnkeywebtools.com/sunshop/
  
  Copyright (c) 2001-2009 Turnkey Web Tools, Inc.
*/
  
$ADDON_NAME 	= "UPS";
$ADDON_FULLNAME	= "United Parcel Service";
$ADDON_VERSION 	= "2.1";
$ADDON_TYPE 	= "Shipping";
$CLASS_NAME 	= "ups";

class ups {
	var $class_vars;
	var $xml_code;
	var $ups_server1 = "https://www.ups.com/ups.app/xml/License";
	var $ups_server2 = "https://www.ups.com/ups.app/xml/Register";
	var $ups_server3 = "https://www.ups.com/ups.app/xml/Track";
	var $dev_key ;
	
	var $shipv = array("01","02","03","07","08","11","12","13","14","54","59","64","65");
		
	var $shipn = array(
		"Next Day Air",
		"2nd Day Air",
		"Ground",
		"Worldwide Express",
		"Worldwide Expidited",
		"Standard",
		"3 Day Select",
		"Next Day Air Saver",
		"Next Day Air Early A.M.",
		"Worldwide Express Plus",
		"2nd Day Air A.M.",
		"Express NAI",
		"Express Saver"
	);
	
	function ups ($class_vars) {
		global $settings;
		$this->class_vars	= $class_vars;
		$this->dev_key		= $settings[dev_key];
	}
	
	function start () {
		global $settings;
		$this->xml_code = '
		<?xml version="1.0"?>
			<AccessRequest xml:lang="en-US">
				<AccessLicenseNumber>'.$settings[upsaccess].'</AccessLicenseNumber>
				<UserId>'.$settings[upsuser].'</UserId>
				<Password>'.$settings[upspass].'</Password>
			</AccessRequest>
		<?xml version="1.0"?>
			<RatingServiceSelectionRequest xml:lang="en-US">
		  	<Request>
				<TransactionReference>
					<CustomerContext></CustomerContext>
					<XpciVersion>1.0001</XpciVersion>
				</TransactionReference>
				<RequestAction>Rate</RequestAction>
				<RequestOption>Rate</RequestOption>
		   </Request>';
	}
	
	function setaddress ($from_city, $from_state, $from_zip, $from_country, $to_city, $to_state, $to_zip, $to_country) {
		switch ($this->class_vars[acc_type]) {
			case '01':
				$pickup_type = "01";
			break;
			case '03':
				$pickup_type = "03";
			break;
			case '04':
				$pickup_type = "11";
			break;
		}
		$this->xml_code .= '
		<CustomerClassification>
			<Code>'.$this->class_vars[acc_type].'</Code>
		</CustomerClassification>
		<PickupType>
			<Code>'.$pickup_type.'</Code>
		</PickupType>
		<Shipment>
			<Shipper>
				<Address>
					<City>'.$from_city.'</City>
					<StateProvinceCode>'.$from_state.'</StateProvinceCode>
					<PostalCode>'.$from_zip.'</PostalCode>
					<CountryCode>'.$from_country.'</CountryCode>
				</Address>
			</Shipper>
			<ShipTo>
		    	<Address>
		      		<City>'.$to_city.'</City>
		    		<StateProvinceCode>'.$to_state.'</StateProvinceCode>
		    		<PostalCode>'.$to_zip.'</PostalCode>
		    		<CountryCode>'.$to_country.'</CountryCode>
		    		<ResidentialAddress/>
				</Address>
			</ShipTo>
			<Service>
		    	<Code><!--//SHIP_CODE//--></Code>
			</Service>';
    }
	
	function add_package($weight, $length="", $width="", $height="") {
		global $settings;
		$this->xml_code .= '
		<Package>
			<PackagingType>
				<Code>'.$this->class_vars[box_type].'</Code>
		    	<Description>Package</Description>
		    </PackagingType>
			<Description>UPS Package</Description>
			<Dimensions>
		    	<UnitOfMeasurement>
		        	<Code>'.(($settings[dimension_units]!="")?$settings[dimension_units]:"IN").'</Code>
		      	</UnitOfMeasurement>
		    	<Length>'.$length.'</Length>
		    	<Width>'.$width.'</Width>
		    	<Height>'.$height.'</Height>
		    </Dimensions>
			<PackageWeight>
		    	<Weight>'.$weight.'</Weight>
		    	<UnitOfMeasurement>
		    		<Code>'.(($settings[weight_units]!="")?$settings[weight_units]."S":"LBS").'</Code>
		    	</UnitOfMeasurement>
		    </PackageWeight>
		</Package>';
	}
	
	function end_all () {
		$this->xml_code .= ' 
			</Shipment>
		</RatingServiceSelectionRequest>';
	}
	
	function process () {
		global $settings, $cconnect, $discounts, $coupon, $set_free;
		$return = array();
		$temp = explode("::", $this->class_vars[accepted]);
		for ($i=0; $i<count($temp); $i++) {
			$meth = $temp[$i];
			$methods[$meth] = 1;
		}
		
		$free = array();
		$temp = explode("::", $this->class_vars[free]);
		for ($i=0; $i<count($temp); $i++) {
			array_push($free, $temp[$i]);
		}
		
		for ($i=0; $i<count($this->shipv); $i++) {
			$temp = $this->shipv[$i];
			if ($methods[$temp] == 1) {
				$set_free = (($discounts[free_shipping]==1 || $coupon[free_shipping]==1) && in_array($temp, $free))?1:0;
				$xml_code = str_replace("<!--//SHIP_CODE//-->", $temp, $this->xml_code);
				
				$header_array = array(
					"POST / HTTP/1.1",
				    "Content-type: application/x-www-form-urlencoded",
				    "Content-length: ".strlen($xml_code)
				);
				
				$header = "POST / HTTP/1.1\r\n".
					"Content-Type: application/x-www-form-urlencoded\r\n".
					"Content-Length: " . strlen ($xml_code) . "\r\n\r\n";
				
				$results = $cconnect->connect($xml_code, $header, $header_array, $this->class_vars[url]);
				$result	= $this->parse_return($results, $i);
				
				$return = array_merge($return, $result);
			}
		}
		
		return $return;
	}
	
	
	function parse_return ($in, $num) {
		global $set_free;
		$return = array();
		$rarray = parse_xml($in);
		
		$return[$num][status]		= $rarray[RatingServiceSelectionResponse][Response][ResponseStatusDescription];
		$return[$num][statuscode]	= $rarray[RatingServiceSelectionResponse][Response][ResponseStatusCode];
		$return[$num][error]		= $rarray[RatingServiceSelectionResponse][Response][Error][ErrorDescription];
		$return[$num][errorcode]	= $rarray[RatingServiceSelectionResponse][Response][Error][ErrorCode];
		$return[$num][rate]			= ($set_free==1)?0:$rarray[RatingServiceSelectionResponse][RatedShipment][TotalCharges][MonetaryValue];
		$return[$num][method]		= $this->shipn[$num];
		
		return $return;
	}
	
	function pre_install_check () {
		global $settings;
		return (($settings[upsaccess]==""))?true:false;
	}
	
	function pre_install () {
		global $DB_site, $dbprefix, $cconnect, $settings, $forms;
		switch ($_GET[step]) {
			case '':
				$vars[heading] = 'UPS OnLine&reg; Tools Licensing & Registration Wizard';
				$vars[content] = template('ups_activate_step1.html', array());
				break;
			case '2':
				$license 		= $this->agreement();
				$license		= ($license=="" || $license == "Error")?"Error connecting to UPS OnLine&reg; Tools. Please make sure your 'cURL Connect' settings are set correctly in the general settings area or hit the refresh button to try again. Also make sure that the backup directory has permissions set to 777.":$license;
				$vars[heading]	= 'UPS OnLine&reg; Tools Licensing & Registration Wizard - Step 1';
				$vars[content]	= template('ups_activate_step2.html', array('license' => $license));
				break;
			case '3':
				$statelist1 = get_data_array('state_country', 'abb',  'type,name', 'WHERE type=\''.STATE.'\' OR type=\'3\'');
				$statelist2 = get_data_array('state_country', 'name',  'type,name', 'WHERE type=\''.STATE.'\' OR type=\'3\'');
				$countrylist1 = get_data_array('state_country', 'abb',  'name', 'WHERE type=\''.COUNTRY.'\'');
				$countrylist2 = get_data_array('state_country', 'name',  'name', 'WHERE type=\''.COUNTRY.'\'');
				
				$form[form]  = $forms->start(array('hide' => 'Form'));
				$form[form] .= $forms->item("textbox", "Contact Name:", "vars[name]", "", $_GET[vars_name], 40, "", array('follow' => '*'));
				$form[form] .= $forms->item("textbox", "Title:", "vars[title]", "", $_GET[vars_title], 40, "", array('follow' => '*'));
				$form[form] .= $forms->item("textbox", "Company Name:", "vars[company]", "", ($_GET[vars_company])?$_GET[vars_company]:$settings[companyname], 40, "", array('follow' => '*'));
				$form[form] .= $forms->item("textbox", "Street Address:", "vars[address1]", "", ($_GET[vars_address1])?$_GET[vars_address1]:$settings[address], 40, "", array('follow' => '*'));
				$form[form] .= $forms->item("textbox", "Street Address 2:", "vars[address2]", "", $_GET[vars_address2], 40);
				$form[form] .= $forms->item("textbox", "City:", "vars[city]", "", ($_GET[vars_city])?$_GET[vars_city]:$settings[city], 40, "", array('follow' => '*'));
				$form[form] .= $forms->item("dropdown", "State/Province:", "vars[state]", $forms->farray($statelist1, $statelist2), ($_GET[vars_state])?$_GET[vars_state]:$settings[state]);
				$form[form] .= $forms->item("textbox", "Postal Code:", "vars[zip]", "", ($_GET[vars_zip])?$_GET[vars_zip]:$settings[zip], 40, "", array('follow' => '*'));
				$form[form] .= $forms->item("dropdown", "Country:", "vars[country]", $forms->farray($countrylist1, $countrylist2), ($_GET[vars_country])?$_GET[vars_country]:$settings[country]);
				$form[form] .= $forms->item("textbox", "Phone Number:", "vars[phone]", "", ($_GET[vars_phone])?$_GET[vars_phone]:$settings[phone], 40, "", array('follow' => '*'));
				$form[form] .= $forms->item("textbox", "Email Address:", "vars[email]", "", ($_GET[vars_email])?$_GET[vars_email]:$settings[contactemail], 40, "", array('follow' => '*'));
				$form[form] .= $forms->item("textbox", "Company URL:", "vars[url]", "", ($_GET[vars_url])?$_GET[vars_url]:$settings[homeurl], 40, "", array('follow' => '*'));
				$form[form] .= $forms->item("textbox", "UPS Account:", "vars[accountnum]", "", $_GET[vars_accountnum], 40);
				$form[form] .= $forms->end(array('hide' => 'Form'));
				
				if ($_POST[agree] == "yes" || $_GET[error]) {
					$form[error] 	= urldecode($_GET[error]);
					$vars[heading]	= 'UPS OnLine&reg; Tools Licensing & Registration Wizard - Step 2';
					$vars[content]	= template('ups_activate_step3.html', $form);
				} else {
					$vars[heading]	= 'UPS OnLine&reg; Tools Licensing & Registration Wizard - Canceled';
					$vars[content]	= '<p><strong>UPS OnLine&reg; Tools Registration Canceled</strong></p>Licensing and registration process has been canceled because you did not agree with the ONLINE&reg; TOOLS ACCESS USER TERMS or you have chosen to cancel the process.';
				}
				break;
			case '4':
				$vars			= $_POST[vars];
				$vars[phone]	= str_replace(array(" ", "-", "(", ")", ".", "X", "x"), "", $vars[phone]);
				$prefix 		= explode("@", $vars[email]);
				$vars[username] = substr($prefix[0], 0, 10).randompass(6);
				$vars[password] = randompass(10);
				
				$results = $this->submit($vars);
				if ($results['Response']['ResponseStatusCode'] != 1 || $results['AccessLicenseNumber'] == "") {
					$msg = ($results['Response']['Error']['ErrorDescription']=="")?"Could not connect to UPS servers. Please retry.":$results['Response']['Error']['ErrorDescription'];
					foreach ($_POST[vars] as $k => $v) $append .= "&vars_$k=$v";
					header('location: adminindex.php?action=settings&sub=module_update&do=pre_install&type='.$_GET[type].'&id='.$_GET[id].'&tab='.$_GET[tab].'&step=3&error='.urlencode($msg).$append);
					exit;
				} else {
					$loop = 0;
					while ($reg_results['ResponseStatusCode'] != 1 && $loop < 5) {
						$vars[username] = substr($prefix[0], 0, 10).randompass(6);
						$reg_results = $this->register_info($vars); $loop++;
					}
					
					$DB_site->query("UPDATE `".$dbprefix."settings` set `value`='".$results['AccessLicenseNumber']."' where `name`='upsaccess'");
					$DB_site->query("UPDATE `".$dbprefix."settings` set `value`='".$vars[username]."' where `name`='upsuser'");
					$DB_site->query("UPDATE `".$dbprefix."settings` set `value`='".$vars[password]."' where `name`='upspass'");
					
					$vars[heading]	= 'UPS OnLine&reg; Tools Licensing & Registration Wizard - Sucessfull';
					$vars[content]	= template('ups_activate_complete.html', array());
				}
				
				break;
			case 'print':
				$license		= nl2br($this->agreement());
				$license		= ($license=="" || $license == "Error")?"Error connecting to UPS OnLine&reg; Tools. Please make sure your 'cURL Connect' settings are set correctly in the general settings area or hit the refresh button to try again. Also make sure that the backup directory has permissions set to 777.":$license;
				$vars[heading]	= 'UPS OnLine&reg; Tools Access User Terms';
				$vars[content]	= template('ups_activate_print.html', array('license' => $license));
				echo template('ups_activate.html', $vars); exit;
				break;
		}
		$form = template('ups_activate.html', $vars);
		return starttable("545", $_GET[id], $form, array());
	}
	
	function agreement () {
		global $cconnect;
		$xml_code		= xml_doc('include/shipping/ups/agreement.xml', array('dev_key' => $this->dev_key));
		$results		= $cconnect->connect($xml_code, "", array(), $this->ups_server1);
		$attributes		= parse_xml($results);
		$license		= $attributes['AccessLicenseAgreementResponse']['AccessLicenseText'];
		$license 		= (valid_utf8($license))?utf8_decode($license):$license;
		return $license;
	}
	
	function submit ($vars) {
		global $cconnect;
		$license 		= $this->agreement();
		$vars 			= array_merge($vars, array('dev_key' => $this->dev_key, 'agreement' => $license));
		$xml_code		= xml_doc('include/shipping/ups/submit.xml', $vars);
		$results		= $cconnect->connect($xml_code, "", array(), $this->ups_server1);
		$attributes		= parse_xml($results);
		return $attributes['AccessLicenseResponse'];
	}
	
	function register_info ($vars) {
		global $cconnect;
		$vars 			= array_merge($vars, array('dev_key' => $this->dev_key));
		$vars[hide]		= ($vars[accountnum]=="")?"Account":"";
		$xml_code		= xml_doc('include/shipping/ups/register.xml', $vars);
		$results		= $cconnect->connect($xml_code, "", array(), $this->ups_server2);
		$attributes		= parse_xml($results);
		return $attributes['RegistrationResponse'];
	}
	
	function install () {
		global $DB_site, $dbprefix;
		$DB_site->query("INSERT INTO ".$dbprefix."modules_shipping set `module`='ups', `internalname`='enabled', `name`='Enabled', `moptions`='', `options`='0::1->Off::On', `value`='0', `help`='', `size`='0', `dorder`='1', `field_type`='dropdown'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_shipping set `module`='ups', `internalname`='url', `name`='', `moptions`='', `options`='', `value`='https://www.ups.com/ups.app/xml/Rate', `help`='', `size`='40', `dorder`='', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_shipping set `module`='ups', `internalname`='acc_type', `name`='UPS Account Type', `moptions`='', `options`='01::03::04->Daily Pickup::Occasional Shipper::Suggested Retail Rate', `value`='03', `help`='Daily Pickup: A UPS driver will come to your location each day (weekly service charge applies, Occasional Shipper: Merchant should have their own account number, and it is the responsibility of the merchant to drop the package into the UPS system, Suggested Retail Rates: Merchants pays for the shipments at the UPS Store (the label is actually created at the UPS Store or UPS Customer Counter)', `size`='0', `dorder`='4', `field_type`='dropdown'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_shipping set `module`='ups', `internalname`='accepted', `name`='Shipping Methods', `moptions`='".implode("::", $this->shipv)."->".implode("::", $this->shipn)."', `options`='', `value`='01::02::03', `help`='', `size`='0', `dorder`='3', `field_type`='dropdown'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_shipping set `module`='ups', `internalname`='free', `name`='Free Methods', `moptions`='".implode("::", $this->shipv)."->".implode("::", $this->shipn)."', `options`='', `value`='03', `help`='Please select any methods you wish to offer free when free shipping is provided using discounts or coupons.', `size`='0', `dorder`='4', `field_type`='dropdown'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_shipping set `module`='ups', `internalname`='box_type', `name`='Typical Box Type', `moptions`='', `options`='01::02::03::04::21::24::25->UPS Letter::Customer Supplied Package::UPS Tube::UPS Pak::UPS Express Box::UPS 25Kg Box::UPS 10Kg Box', `value`='02', `help`='', `size`='0', `dorder`='5', `field_type`='dropdown'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_shipping set `module`='ups', `internalname`='multi_support', `name`='', `moptions`='', `options`='', `value`='1', `help`='', `size`='0', `dorder`='', `field_type`='textbox'");
	}
	
	function uninstall () {
		global $DB_site, $dbprefix;
		$DB_site->query("DELETE FROM ".$dbprefix."modules_shipping where `module`='ups'");
	}
}
?>
